<?php
/**
 * The style "Modern" of the Blogger
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_blogger');

if ($args['slider']) {
	?><div class="slider-slide swiper-slide"><?php
} else if ((int)$args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

$post_format = get_post_format();
$post_format = empty($post_format) ? 'standard' : str_replace('post-format-', '', $post_format);
$post_link = empty($args['no_links']) ? get_permalink() : '';
$post_title = get_the_title();
$has_thumb = has_post_thumbnail();

$tags = get_the_tag_list( '<span class="post_meta_item post_tags"><span class="post_meta_label">'.'</span> ', ' ', '</span>' );

?><div <?php post_class( 'sc_blogger_item post_format_'.esc_attr($post_format) . (empty($post_link) ? ' no_links' : ''). ($has_thumb ? ' with-img' : ' without-img') ); ?>><?php

	// Featured image
	if ($has_thumb) {

		trx_addons_get_template_part('templates/tpl.featured.php',
			'trx_addons_args_featured',
			apply_filters('trx_addons_filter_args_featured', array(
				'class' => 'sc_blogger_item_featured',
				'hover' => 'zoomin',
				'no_links' => empty($post_link),
				'post_info' => !empty($tags) ? '<div class="post_info"><div class="post_tags">' . $tags . '</div></div>' : '',
				'thumb_size' => apply_filters('trx_addons_filter_thumb_size', jack_well_get_thumb_size('extra'), 'blogger-modern')
			), 'blogger-modern')
		);

	}

	// Post content
	?><div class="sc_blogger_item_content entry-content"><?php

		// Post title
		?><div class="sc_blogger_item_header entry-header"><?php 
			// Post meta
			$post_meta = trx_addons_sc_show_post_meta('sc_blogger', apply_filters('trx_addons_filter_show_post_meta', array(
				'components' => 'date,counters',
				'counters' => 'comments',
				'echo' => false
				), 'sc_blogger_modern', $args['columns'])
			);
			if (empty($post_link)) $post_meta = trx_addons_links_to_span($post_meta);
			trx_addons_show_layout($post_meta);		
			// Post title
			the_title( '<h5 class="sc_blogger_item_title entry-title">'
							. (!empty($post_link)
								? sprintf( '<a href="%s" rel="bookmark">', esc_url( $post_link ) )
								: ''),
						(!empty($post_link) ? '</a>' : '') . '</h5>' );
		?></div><!-- .entry-header --><?php

		// Post excerpt
		if (!isset($args['hide_excerpt']) || (int)$args['hide_excerpt']==0) {
			?><div class="sc_blogger_item_excerpt">
				<div class="sc_blogger_item_excerpt_text">
					<?php
					$show_more = !in_array($post_format, array('link', 'aside', 'status'));
					if (has_excerpt()) {
						the_excerpt();
					} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
						the_content( '' );
					} else if (!$show_more) {
						the_content();
					} else {
						the_excerpt();
					}
					?>
				</div>
				<?php
				// Post meta
				if (in_array($post_format, array('link', 'aside', 'status'))) {
					trx_addons_sc_show_post_meta('sc_blogger', apply_filters('trx_addons_filter_show_post_meta', array(
						'components' => 'date'
						), 'sc_blogger_modern', $args['columns'])
					);
				}
				// More button
				if ( $show_more && !empty($post_link) && !empty($args['more_text']) ) {
					?><div class="sc_blogger_item_button sc_item_button"><a href="<?php echo esc_url($post_link); ?>" class="<?php echo esc_attr(apply_filters('trx_addons_filter_sc_item_link_classes', 'sc_button sc_button_default sc_button_size_small', 'sc_blogger', $args)); ?>"><?php
						echo esc_html($args['more_text']);
					?></a></div><?php
				}

				// Post meta
				$author_id = get_the_author_meta('ID');
				if (empty($author_id) && !empty($GLOBALS['post']->post_author))
					$author_id = $GLOBALS['post']->post_author;
				if ((int)$author_id > 0) {
					$author_link = get_author_posts_url($author_id);
					$author_name = get_the_author_meta('display_name', $author_id);
					?>
					<a class="post_meta_item post_author" rel="author" href="<?php echo esc_url($author_link); ?>">
						<?php echo esc_html_e('by ', 'jack-well').esc_html($author_name); ?>
					</a>
				<?php
			}
			?></div><!-- .sc_blogger_item_excerpt --><?php
		}
	?></div><!-- .entry-content --><?php
	
?></div><!-- .sc_blogger_item --><?php

if ($args['slider'] || (int)$args['columns'] > 1) {
	?></div><?php
}
?>