<?php
/**
 * The style "default" of the Blogger
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_blogger');

if ($args['slider']) {
	?><div class="slider-slide swiper-slide"><?php
} else if ((int)$args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

$post_format = get_post_format();
$post_format = empty($post_format) ? 'standard' : str_replace('post-format-', '', $post_format);
$post_link = empty($args['no_links']) ? get_permalink() : '';
$post_title = get_the_title();

$audio = '';
$output_audio ='';
if ($post_format == 'audio') {
	$post_content = '';

    $audio = jack_well_get_post_audio($post_content, false);
    if (empty($audio))
    $audio = jack_well_get_post_iframe($post_content, false);

    if (!empty($audio)) {
		$args2 = array(
			'link' => $audio,               // Link to the audio
			'popup' => true,                // Open audio in the popup window or insert instead cover image (default)
		);

		$args2['id'] = 'sc_audio_' . str_replace('.', '', mt_rand());
		$output_audio = '<div id="' . esc_attr($args2['id']) . '"'
			. ' class="trx_addons_audio_player'
			. ' hover_play'
			. '"'
			. '>';

        $args2['embed'] = $audio;
		$output_audio .='<a class="post_link trx_addons_popup_link blogger_audio_link" href="#' . esc_attr($args2['id']) . '_popup"></a>';
		$output_audio .= '</div>';

		// Add popup
		if (!empty($args2['popup'])) {
			$output_audio .= '<!-- .sc_popup --><div id="' . esc_attr($args2['id']) . '_popup" class="sc_popup">'
				. '<div id="' . esc_attr($args2['id']) . '_popup_player"'
				. ' class="trx_addons_audio_player without_cover'
				. (!empty($args2['class']) ? ' ' . esc_attr($args2['class']) : '')
				. '"'
				. '>'
				. '<div class="audio_embed audio_frame">'
				. '<span class="post_meta_item post_date"><a href="' . esc_url(get_permalink()). '">' .wp_kses_data(apply_filters('trx_addons_filter_get_post_date', get_the_date())).'</a></span>'
				 .'<h4 class="blogger_audio_popup_title">'. $post_title .'</h4>'
				. str_replace('wp-audio-shortcode', 'wp-audio-shortcode-noinit', $args2['embed'])
				. '</audio>'
				. '</div>'
				. '</div>'
				. '</div>';
		}
	}
}



?><div <?php post_class( 'sc_blogger_item post_format_'.esc_attr($post_format) . (empty($post_link) ? ' no_links' : '') . ( !empty($output_audio) ? ' with_popup' : '' ) ); ?>>
<div class="blogger_audio_date">
	<?php if ($post_format === 'audio' && !empty($output_audio)){ ?><span class="speech-date"><?php esc_html_e('Speech from', 'jack-well'); ?></span><?php } ?>
	<span class="post_meta_item post_date"><a href="<?php the_permalink(); ?>"><?php echo wp_kses_data(apply_filters('trx_addons_filter_get_post_date', get_the_date())); ?></a></span>
</div>

<div class="sc_post_thumb"><?php
	$has_thumb = has_post_thumbnail();
	if ($has_thumb) {
		the_post_thumbnail(jack_well_get_thumb_size('masonry-big'), array('alt' => the_title_attribute( array( 'echo' => false ))));
	}?>
</div>

	<div class="sc_blogger_item_content entry-content"><?php
		// Post title
		if ( !in_array($post_format, array('link', 'aside', 'status', 'quote')) ) {	// Post title
				the_title( '<h5 class="sc_blogger_item_title entry-title">' . (!empty($post_link) ? sprintf( '<a href="%s" rel="bookmark">', esc_url( $post_link ) ) : ''), (!empty($post_link) ? '</a>' : '') . '</h5>' );
		}

		// Post content
		if (!isset($args['hide_excerpt']) || (int)$args['hide_excerpt']==0) {
			?><div class="sc_blogger_item_excerpt">
				<div class="sc_blogger_item_excerpt_text">
					<?php
					$show_more = !in_array($post_format, array('link', 'aside', 'status', 'quote'));
					if (has_excerpt()) {
						the_excerpt();
					} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
						the_content( '' );
					} else if (!$show_more) {
						the_content();
					} else {
						the_excerpt();
					}
					?>
				</div>
				<?php
				// More button
				if ( $show_more && !empty($post_link) && !empty($args['more_text']) ) {
					?><div class="sc_blogger_item_button sc_item_button"><a href="<?php echo esc_url($post_link); ?>" class="<?php echo esc_attr(apply_filters('trx_addons_filter_sc_item_link_classes', 'sc_button sc_button_normal sc_button_size_small', 'sc_blogger', $args)); ?>"><?php
						echo esc_html($args['more_text']);
					?></a></div><?php
				}
			?></div><!-- .sc_blogger_item_excerpt --><?php
		}

		if( !empty($audio) ){ ?>
			<div class="blogger_audio_wrap">
			<?php jack_well_show_layout($output_audio); ?>
			</div><?php
		}

	?></div><!-- .entry-content --><?php
	
?></div><!-- .sc_blogger_item --><?php

if ($args['slider'] || (int)$args['columns'] > 1) {
	?></div><?php
}
?>