<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0.22
 */

if (!defined("JACK_WELL_THEME_FREE"))		define("JACK_WELL_THEME_FREE", false);
if (!defined("JACK_WELL_THEME_FREE_WP"))	define("JACK_WELL_THEME_FREE_WP", false);

// Theme storage
$JACK_WELL_STORAGE = array(
	// Theme required plugin's slugs
	'required_plugins' => array_merge(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'					=> esc_html__('ThemeREX Addons', 'jack-well'),
			
			// Recommended (supported) plugins fot both (lite and full) versions
			// If plugin not need - comment (or remove) it
			'contact-form-7'				=> esc_html__('Contact Form 7', 'jack-well'),
			'give'				            => esc_html__('Give Donation', 'jack-well'),
			'mailchimp-for-wp'				=> esc_html__('MailChimp for WP', 'jack-well')
		),

		// List of plugins for the FREE version only
		//-----------------------------------------------------
		JACK_WELL_THEME_FREE 
			? array(
					// Recommended (supported) plugins for the FREE (lite) version

					) 

		// List of plugins for the PREMIUM version only
		//-----------------------------------------------------
			: array(
					// Recommended (supported) plugins for the PRO (full) version
					// If plugin not need - comment (or remove) it
					'essential-grid'			=> esc_html__('Essential Grid', 'jack-well'),
					'revslider'					=> esc_html__('Revolution Slider', 'jack-well'),
					'the-events-calendar'		=> esc_html__('The Events Calendar', 'jack-well'),
					'trx_updater'				=> esc_html__('ThemeREX Updater', 'jack-well'),
					'js_composer'				=> esc_html__('WPBakery Page Builder', 'jack-well'),
					'wp-gdpr-compliance'    => esc_html__('Cookie Information', 'jack-well'),
					)
	),
	
	// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
	'theme_pro_key'		=> JACK_WELL_THEME_FREE 
								? 'env-ancora'
								: '',

	// Theme-specific URLs (will be escaped in place of the output)
	'theme_demo_url'	=> '//jack-well.ancorathemes.com',
	'theme_doc_url'		=> '//jack-well.ancorathemes.com/doc',
	'theme_download_url'=> '//themeforest.net/item/jack-well-elections-campaign-political-wordpress-theme/22311876',

	'theme_support_url'	=> 'https://themerex.net/support/',
	'theme_video_url'	=> 'https://www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',


	// Responsive resolutions
	// Parameters to create css media query: min, max, 
	'responsive'		=> array(
						// By device
						'desktop'	=> array('min' => 1680),
						'notebook'	=> array('min' => 1280, 'max' => 1679),
						'tablet'	=> array('min' =>  768, 'max' => 1279),
						'mobile'	=> array('max' =>  767),
						// By size
						'xxl'		=> array('max' => 1679),
						'xl'		=> array('max' => 1439),
						'lg'		=> array('max' => 1279),
						'md'		=> array('max' => 1023),
						'sm'		=> array('max' =>  767),
						'sm_wp'		=> array('max' =>  600),
						'xs'		=> array('max' =>  479)
						)
);

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( !function_exists('jack_well_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'jack_well_customizer_theme_setup1', 1 );
	function jack_well_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		jack_well_storage_set('settings', array(
			
			'duplicate_options'		=> 'child',		// none  - use separate options for the main and the child-theme
													// child - duplicate theme options from the main theme to the child-theme only
													// both  - sinchronize changes in the theme options between main and child themes

			'customize_refresh'		=> 'auto',		// Refresh method for preview area in the Appearance - Customize:
													// auto - refresh preview area on change each field with Theme Options
													// manual - refresh only obn press button 'Refresh' at the top of Customize frame

			'max_load_fonts'		=> 5,			// Max fonts number to load from Google fonts or from uploaded fonts

			'comment_maxlength'		=> 1000,		// Max length of the message from contact form

			'comment_after_name'	=> true,		// Place 'comment' field before the 'name' and 'email'

			'socials_type'			=> 'icons',		// Type of socials:
													// icons - use font icons to present social networks
													// images - use images from theme's folder trx_addons/css/icons.png

			'icons_type'			=> 'icons',		// Type of other icons:
													// icons - use font icons to present icons
													// images - use images from theme's folder trx_addons/css/icons.png

			'icons_selector'		=> 'internal',	// Icons selector in the shortcodes:
													// vc (default) - standard VC or Elementor's icons selector (very slow and don't support images)
													// internal - internal popup with plugin's or theme's icons list (fast)
			'check_min_version'		=> true,		// Check if exists a .min version of .css and .js and return path to it
													// instead the path to the original file
													// (if debug_mode is off and modification time of the original file < time of the .min file)
			'autoselect_menu'		=> false,		// Show any menu if no menu selected in the location 'main_menu'
													// (for example, the theme is just activated)
			'disable_jquery_ui'		=> false,		// Prevent loading custom jQuery UI libraries in the third-party plugins
		
			'use_mediaelements'		=> true,		// Load script "Media Elements" to play video and audio
			
			'tgmpa_upload'			=> false,		// Allow upload not pre-packaged plugins via TGMPA
			
			'allow_no_image'		=> false,		// Allow use image placeholder if no image present in the blog, related posts, post navigation, etc.

			'separate_schemes'		=> true 		// Save color schemes to the separate files __color_xxx.css (true) or append its to the __custom.css (false)
		));


		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		
		jack_well_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Roboto',
				'family' => 'sans-serif',
				'styles' => '300,300italic,400,400italic,700,700italic'		// Parameter 'style' used only for the Google fonts
				),
			array(
				'name'	 => 'Merriweather',
				'family' => 'serif',
				'styles' => '300,300italic,400,400italic,700,700italic,900,900italic'		// Parameter 'style' used only for the Google fonts
			),
			array(
				'name'	 => 'Overpass',
				'family' => 'sans-serif',
				'styles' => '100,100italic,300,300italic,400,400italic,600,600italic,700,700italic,800,800italic,900,900italic'		// Parameter 'style' used only for the Google fonts
			),
			array(
				'name'	 => 'Rufina',
				'family' => 'serif',
				'styles' => '400,700'		// Parameter 'style' used only for the Google fonts
			),
			array(
				'name'	 => 'Yesteryear',
				'family' => 'cursive',
				'styles' => '400'		// Parameter 'style' used only for the Google fonts
			),
			// Font-face packed with theme
			array(
				'name'   => 'Montserrat',
				'family' => 'sans-serif'
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		jack_well_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		// Attention! Font name in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!

		jack_well_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'jack-well'),
				'description'		=> esc_html__('Font settings of the main text of the site. Attention! For correct display of the site on mobile devices, use only units "rem", "em" or "ex"', 'jack-well'),
				'font-family'		=> '"Merriweather",serif',
				'font-size' 		=> '1rem',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.7138em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.01em',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '1.75em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'jack-well'),
				'font-family'		=> '"Rufina",serif',
				'font-size' 		=> '4.643em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.1538em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.025em',
				'margin-top'		=> '1.6em',
				'margin-bottom'		=> '1.0462em;'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'jack-well'),
				'font-family'		=> '"Rufina",serif',
				'font-size' 		=> '3.929em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.1818em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.025em',
				'margin-top'		=> '1.3635em',
				'margin-bottom'		=> '1.091em'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'jack-well'),
				'font-family'		=> '"Rufina",serif',
				'font-size' 		=> '2.571em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.3335em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.025em',
				'margin-top'		=> '1.778em',
				'margin-bottom'		=> '1.1665em'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'jack-well'),
				'font-family'		=> '"Rufina",serif',
				'font-size' 		=> '2.143em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.267em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.025em',
				'margin-top'		=> '1.8665em',
				'margin-bottom'		=> '1.2em'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'jack-well'),
				'font-family'		=> '"Rufina",serif',
				'font-size' 		=> '1.571em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.364em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.025em',
				'margin-top'		=> '2.182em',
				'margin-bottom'		=> '1.182em'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'jack-well'),
				'font-family'		=> '"Rufina",serif',
				'font-size' 		=> '1.286em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.444em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.025em',
				'margin-top'		=> '1.444em',
				'margin-bottom'		=> '1.333em'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'jack-well'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'jack-well'),
				'font-family'		=> '"Merriweather",sans',
				'font-size' 		=> '1.8em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '1px'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'jack-well'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '14px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '18px',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0.1em'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'jack-well'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'jack-well'),
				'font-family'		=> 'inherit',
				'font-size' 		=> '1em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',	// Attention! Firefox don't allow line-height less then 1.5em in the select
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'jack-well'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'jack-well'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '14px',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'uppercase',
				'letter-spacing'	=> '0.075em',
				'margin-top'		=> '',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'jack-well'),
				'description'		=> esc_html__('Font settings of the main menu items', 'jack-well'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '1.143em',
				'font-weight'		=> '700',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.01em'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'jack-well'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'jack-well'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '-0.01em'
				),
			'bq_author' => array(
				'title'				=> esc_html__('Blockquote Author', 'jack-well'),
				'description'		=> esc_html__('Font settings of the blockquote author item', 'jack-well'),
				'font-family'		=> '"Yesteryear",cursive'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		jack_well_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> esc_html__('Main', 'jack-well'),
							'description'	=> esc_html__('Colors of the main content area', 'jack-well')
							),
			'alter'	=> array(
							'title'			=> esc_html__('Alter', 'jack-well'),
							'description'	=> esc_html__('Colors of the alternative blocks (sidebars, etc.)', 'jack-well')
							),
			'extra'	=> array(
							'title'			=> esc_html__('Extra', 'jack-well'),
							'description'	=> esc_html__('Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'jack-well')
							),
			'inverse' => array(
							'title'			=> esc_html__('Inverse', 'jack-well'),
							'description'	=> esc_html__('Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'jack-well')
							),
			'input'	=> array(
							'title'			=> esc_html__('Input', 'jack-well'),
							'description'	=> esc_html__('Colors of the form fields (text field, textarea, select, etc.)', 'jack-well')
							),
			)
		);
		jack_well_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> esc_html__('Background color', 'jack-well'),
							'description'	=> esc_html__('Background color of this block in the normal state', 'jack-well')
							),
			'bg_hover'	=> array(
							'title'			=> esc_html__('Background hover', 'jack-well'),
							'description'	=> esc_html__('Background color of this block in the hovered state', 'jack-well')
							),
			'bd_color'	=> array(
							'title'			=> esc_html__('Border color', 'jack-well'),
							'description'	=> esc_html__('Border color of this block in the normal state', 'jack-well')
							),
			'bd_hover'	=>  array(
							'title'			=> esc_html__('Border hover', 'jack-well'),
							'description'	=> esc_html__('Border color of this block in the hovered state', 'jack-well')
							),
			'text'		=> array(
							'title'			=> esc_html__('Text', 'jack-well'),
							'description'	=> esc_html__('Color of the plain text inside this block', 'jack-well')
							),
			'text_dark'	=> array(
							'title'			=> esc_html__('Text dark', 'jack-well'),
							'description'	=> esc_html__('Color of the dark text (bold, header, etc.) inside this block', 'jack-well')
							),
			'text_light'=> array(
							'title'			=> esc_html__('Text light', 'jack-well'),
							'description'	=> esc_html__('Color of the light text (post meta, etc.) inside this block', 'jack-well')
							),
			'text_link'	=> array(
							'title'			=> esc_html__('Link', 'jack-well'),
							'description'	=> esc_html__('Color of the links inside this block', 'jack-well')
							),
			'text_hover'=> array(
							'title'			=> esc_html__('Link hover', 'jack-well'),
							'description'	=> esc_html__('Color of the hovered state of links inside this block', 'jack-well')
							),
			'text_link2'=> array(
							'title'			=> esc_html__('Link 2', 'jack-well'),
							'description'	=> esc_html__('Color of the accented texts (areas) inside this block', 'jack-well')
							),
			'text_hover2'=> array(
							'title'			=> esc_html__('Link 2 hover', 'jack-well'),
							'description'	=> esc_html__('Color of the hovered state of accented texts (areas) inside this block', 'jack-well')
							),
			'text_link3'=> array(
							'title'			=> esc_html__('Link 3', 'jack-well'),
							'description'	=> esc_html__('Color of the other accented texts (buttons) inside this block', 'jack-well')
							),
			'text_hover3'=> array(
							'title'			=> esc_html__('Link 3 hover', 'jack-well'),
							'description'	=> esc_html__('Color of the hovered state of other accented texts (buttons) inside this block', 'jack-well')
							)
			)
		);
		jack_well_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'jack-well'),
				'internal' => true,
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#ffffff',
					'bd_color'			=> '#e7e7e1',
		
					// Text and links colors
					'text'				=> '#6c6a6a',
					'text_light'		=> '#9d9da0',
					'text_dark'			=> '#1a1d32',
					'text_link'			=> '#deb668',
					'text_hover'		=> '#064694',
					'text_link2'		=> '#80d572',
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#f3f3f0',
					'alter_bg_hover'	=> '#d9d9d7',
					'alter_bd_color'	=> '#e7e7e1',
					'alter_bd_hover'	=> '#dadada',
					'alter_text'		=> '#6c6a6a',
					'alter_light'		=> '#9d9da0',
					'alter_dark'		=> '#1a1d32',
					'alter_link'		=> '#deb668',
					'alter_hover'		=> '#064694',
					'alter_link2'		=> '#f3f3f0',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',
		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#022147',
					'extra_bg_hover'	=> '#064694',
					'extra_bd_color'	=> '#e7e7e1',
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#8b8b8e',
					'extra_light'		=> '#9d9da0',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#deb668',
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#ffffff',
					'input_bg_hover'	=> '#ffffff',
					'input_bd_color'	=> '#f3f3f0',
					'input_bd_hover'	=> '#deb668',
					'input_text'		=> '#6c6a6a',
					'input_light'		=> '#6c6a6a',
					'input_dark'		=> '#758799',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#67bcc1',
					'inverse_bd_hover'	=> '#5aa4a9',
					'inverse_text'		=> '#ffffff',
					'inverse_light'		=> '#333333',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#064694',
					'inverse_hover'		=> '#ffffff'
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'jack-well'),
				'internal' => true,
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#011732',
					'bd_color'			=> '#082c59',
		
					// Text and links colors
					'text'				=> '#e0e0e1',
					'text_light'		=> '#a7a7a7',
					'text_dark'			=> '#ffffff',
					'text_link'			=> '#deb668',
					'text_hover'		=> '#064694',
					'text_link2'		=> '#80d572',
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#022147',
					'alter_bg_hover'	=> '#001227',
					'alter_bd_color'	=> '#011732',
					'alter_bd_hover'	=> '#4a4a4a',
					'alter_text'		=> '#e0e0e1',
					'alter_light'		=> '#a7a7a7',
					'alter_dark'		=> '#ffffff',
					'alter_link'		=> '#deb668',
					'alter_hover'		=> '#064694',
					'alter_link2'		=> '#deb668',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#deb668',
					'extra_bg_hover'	=> '#deb668',
					'extra_bd_color'	=> '#011732',
					'extra_bd_hover'	=> '#4a4a4a',
					'extra_text'		=> '#e0e0e1',
					'extra_light'		=> '#a7a7a7',
					'extra_dark'		=> '#1a1d32',
					'extra_link'		=> '#064694',
					'extra_hover'		=> '#fe7259',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#001227',
					'input_bg_hover'	=> '#001227',
					'input_bd_color'	=> '#022147',
					'input_bd_hover'	=> '#deb668',
					'input_text'		=> '#ffffff',
					'input_light'		=> '#6c6a6a',
					'input_dark'		=> '#ffffff',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#ffffff',
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#062a4d'
				)
			)
		
		));
		
		// Simple schemes substitution
		jack_well_storage_set('schemes_simple', array(
			// Main color	// Slave elements and it's darkness koef.
			'text_link'		=> array('alter_hover' => 1,	'extra_link' => 1, 'inverse_bd_color' => 0.85, 'inverse_bd_hover' => 0.7),
			'text_hover'	=> array('alter_link' => 1,		'extra_hover' => 1),
			'text_link2'	=> array('alter_hover2' => 1,	'extra_link2' => 1),
			'text_hover2'	=> array('alter_link2' => 1,	'extra_hover2' => 1),
			'text_link3'	=> array('alter_hover3' => 1,	'extra_link3' => 1),
			'text_hover3'	=> array('alter_link3' => 1,	'extra_hover3' => 1)
		));

		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		jack_well_storage_set('scheme_colors_add', array(
			'bg_color_0'		=> array('color' => 'bg_color',			'alpha' => 0),
			'bg_color_02'		=> array('color' => 'bg_color',			'alpha' => 0.2),
			'bg_color_07'		=> array('color' => 'bg_color',			'alpha' => 0.7),
			'bg_color_08'		=> array('color' => 'bg_color',			'alpha' => 0.8),
			'bg_color_09'		=> array('color' => 'bg_color',			'alpha' => 0.9),
			'alter_bg_color_07'	=> array('color' => 'alter_bg_color',	'alpha' => 0.7),
			'alter_bg_color_04'	=> array('color' => 'alter_bg_color',	'alpha' => 0.4),
			'alter_bg_color_02'	=> array('color' => 'alter_bg_color',	'alpha' => 0.2),
			'alter_bd_color_02'	=> array('color' => 'alter_bd_color',	'alpha' => 0.2),
			'alter_link_02'		=> array('color' => 'alter_link',		'alpha' => 0.2),
			'alter_link_07'		=> array('color' => 'alter_link',		'alpha' => 0.7),
			'extra_bg_color_07'	=> array('color' => 'extra_bg_color',	'alpha' => 0.7),
			'extra_link_02'		=> array('color' => 'extra_link',		'alpha' => 0.2),
			'extra_link_07'		=> array('color' => 'extra_link',		'alpha' => 0.7),
			'text_dark_015'		=> array('color' => 'text_dark',		'alpha' => 0.15),
			'text_dark_07'		=> array('color' => 'text_dark',		'alpha' => 0.7),
			'text_link_02'		=> array('color' => 'text_link',		'alpha' => 0.2),
			'text_link_07'		=> array('color' => 'text_link',		'alpha' => 0.7),
			'text_link_blend'	=> array('color' => 'text_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5),
			'alter_link_blend'	=> array('color' => 'alter_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5)
		));
		
		// Parameters to set order of schemes in the css
		jack_well_storage_set('schemes_sorted', array(
													'color_scheme', 'header_scheme', 'menu_scheme', 'sidebar_scheme', 'footer_scheme'
													));
		
		
		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		jack_well_storage_set('theme_thumbs', apply_filters('jack_well_filter_add_thumb_sizes', array(
			// Width of the image is equal to the content area width (without sidebar)
			// Height is fixed
			'jack_well-thumb-huge'		=> array(
												'size'	=> array(1170, 658, true),
												'title' => esc_html__( 'Huge image', 'jack-well' ),
												'subst'	=> 'trx_addons-thumb-huge'
												),
			// Width of the image is equal to the content area width (with sidebar)
			// Height is fixed
			'jack_well-thumb-big' 		=> array(
												'size'	=> array( 760, 428, true),
												'title' => esc_html__( 'Large image', 'jack-well' ),
												'subst'	=> 'trx_addons-thumb-big'
												),
			// Width of the image is equal to the content area width (with sidebar)
			// Height is fixed
			'jack_well-thumb-extra' 		=> array(
												'size'	=> array( 760, 760, true),
												'title' => esc_html__( 'Extra image', 'jack-well' ),
												'subst'	=> 'trx_addons-thumb-big'
											),

			// Width of the image is equal to the 1/3 of the content area width (without sidebar)
			// Height is fixed
			'jack_well-thumb-med' 		=> array(
												'size'	=> array( 370, 208, true),
												'title' => esc_html__( 'Medium image', 'jack-well' ),
												'subst'	=> 'trx_addons-thumb-medium'
												),

			// Small square image (for avatars in comments, etc.)
			'jack_well-thumb-tiny' 		=> array(
												'size'	=> array(  100,  100, true),
												'title' => esc_html__( 'Small square avatar', 'jack-well' ),
												'subst'	=> 'trx_addons-thumb-tiny'
												),

			// Width of the image is equal to the content area width (with sidebar)
			// Height is proportional (only downscale, not crop)
			'jack_well-thumb-masonry-big' => array(
												'size'	=> array( 760,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry Large (scaled)', 'jack-well' ),
												'subst'	=> 'trx_addons-thumb-masonry-big'
												),

			// Width of the image is equal to the 1/3 of the full content area width (without sidebar)
			// Height is proportional (only downscale, not crop)
			'jack_well-thumb-masonry'		=> array(
												'size'	=> array( 370,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry (scaled)', 'jack-well' ),
												'subst'	=> 'trx_addons-thumb-masonry'
												)
			))
		);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( !function_exists( 'jack_well_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'jack_well_importer_set_options', 9 );
	function jack_well_importer_set_options($options=array()) {
		if (is_array($options)) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Prepare demo data
			$options['demo_url'] = esc_url(jack_well_get_protocol() . '://demofiles.ancorathemes.com/jack-well');
			// Required plugins
			$options['required_plugins'] = array_keys(jack_well_storage_get('required_plugins'));
			// Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 3;
			// Default demo
			$options['files']['default']['title'] = esc_html__('Jack Well Demo', 'jack-well');
			$options['files']['default']['domain_dev']  = jack_well_add_protocol( '//jack-well.ancorathemes.com' );                // Developers domain
			$options['files']['default']['domain_demo'] = jack_well_add_protocol( jack_well_storage_get( 'theme_demo_url' ) );   // Demo-site domain
			// If theme need more demo - just copy 'default' and change required parameter

			// Banners
			$options['banners'] = array(
				array(
					'image' => jack_well_get_file_url('theme-specific/theme-about/images/frontpage.png'),
					'title' => esc_html__('Front Page Builder', 'jack-well'),
					'content' => wp_kses(__("Create your front page right in the WordPress Customizer. There's no need in WPBakery Page Builder, or any other builder. Simply enable/disable sections, fill them out with content, and customize to your liking.", 'jack-well'), 'jack_well_kses_content' ),
					'link_url' => esc_url('//www.youtube.com/watch?v=VT0AUbMl_KA'),
					'link_caption' => esc_html__('Watch Video Introduction', 'jack-well'),
					'duration' => 20
					),
				array(
					'image' => jack_well_get_file_url('theme-specific/theme-about/images/layouts.png'),
					'title' => esc_html__('Layouts Builder', 'jack-well'),
					'content' => wp_kses(__('Use Layouts Builder to create and customize header and footer styles for your website. With a flexible page builder interface and custom shortcodes, you can create as many header and footer layouts as you want with ease.', 'jack-well'), 'jack_well_kses_content' ),
					'link_url' => esc_url('//www.youtube.com/watch?v=pYhdFVLd7y4'),
					'link_caption' => esc_html__('Learn More', 'jack-well'),
					'duration' => 20
					),
				array(
					'image' => jack_well_get_file_url('theme-specific/theme-about/images/documentation.png'),
					'title' => esc_html__('Read Full Documentation', 'jack-well'),
					'content' => wp_kses(__('Need more details? Please check our full online documentation for detailed information on how to use Jack Well.', 'jack-well'), 'jack_well_kses_content' ),
					'link_url' => esc_url(jack_well_storage_get('theme_doc_url')),
					'link_caption' => esc_html__('Online Documentation', 'jack-well'),
					'duration' => 15
					),
				array(
					'image' => jack_well_get_file_url('theme-specific/theme-about/images/video-tutorials.png'),
					'title' => esc_html__('Video Tutorials', 'jack-well'),
					'content' => wp_kses(__('No time for reading documentation? Check out our video tutorials and learn how to customize Jack Well in detail.', 'jack-well'), 'jack_well_kses_content' ),
					'link_url' => esc_url(jack_well_storage_get('theme_video_url')),
					'link_caption' => esc_html__('Video Tutorials', 'jack-well'),
					'duration' => 15
					),
				array(
					'image' => jack_well_get_file_url('theme-specific/theme-about/images/studio.png'),
					'title' => esc_html__('Website Customization', 'jack-well'),
					'content' => wp_kses(__("Need a website fast? Order our custom service, and we'll build a website based on this theme for a very fair price. We can also implement additional functionality such as website translation, setting up WPML, and much more.", 'jack-well'), 'jack_well_kses_content' ),
					'link_url' => esc_url('//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themedash'),
					'link_caption' => esc_html__('Contact Us', 'jack-well'),
					'duration' => 25
					)
				);
		}
		return $options;
	}
}




// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('jack_well_create_theme_options')) {

	function jack_well_create_theme_options() {

		// Message about options override. 
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = __('Attention! Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages', 'jack-well');
		
		// Color schemes number: if < 2 - hide fields with selectors
		$hide_schemes = count(jack_well_storage_get('schemes')) < 2;
		
		jack_well_storage_set('options', array(
		
			// 'Logo & Site Identity'
			'title_tagline' => array(
				"title" => esc_html__('Logo & Site Identity', 'jack-well'),
				"desc" => '',
				"priority" => 10,
				"type" => "section"
				),
			'logo_info' => array(
				"title" => esc_html__('Logo in the header', 'jack-well'),
				"desc" => '',
				"priority" => 20,
				"type" => "info",
				),
			'logo_text' => array(
				"title" => esc_html__('Use Site Name as Logo', 'jack-well'),
				"desc" => wp_kses_data( __('Use the site title and tagline as a text logo if no image is selected', 'jack-well') ),
				"class" => "jack_well_column-1_2 jack_well_new_row",
				"priority" => 30,
				"std" => 1,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_retina_enabled' => array(
				"title" => esc_html__('Allow retina display logo', 'jack-well'),
				"desc" => wp_kses_data( __('Show fields to select logo images for Retina display', 'jack-well') ),
				"class" => "jack_well_column-1_2",
				"priority" => 40,
				"refresh" => false,
				"std" => 0,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_zoom' => array(
				"title" => esc_html__('Logo zoom', 'jack-well'),
				"desc" => wp_kses_data( __("Zoom the logo. 1 - original size. Maximum size of logo depends on the actual size of the picture", 'jack-well') ),
				"std" => 1,
				"min" => 0.2,
				"max" => 2,
				"step" => 0.1,
				"refresh" => false,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "slider"
				),
			// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'jack-well') ),
				"class" => "jack_well_column-1_2",
				"priority" => 70,
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile_header' => array(
				"title" => esc_html__('Logo for the mobile header', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'jack-well') ),
				"class" => "jack_well_column-1_2 jack_well_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_header_retina' => array(
				"title" => esc_html__('Logo for the mobile header for Retina', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'jack-well') ),
				"class" => "jack_well_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile' => array(
				"title" => esc_html__('Logo mobile', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile menu', 'jack-well') ),
				"class" => "jack_well_column-1_2 jack_well_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_retina' => array(
				"title" => esc_html__('Logo mobile for Retina', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'jack-well') ),
				"class" => "jack_well_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'jack-well') ),
				"class" => "jack_well_column-1_2 jack_well_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'jack-well') ),
				"class" => "jack_well_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "image"
				),
			
		
		
			// 'General settings'
			'general' => array(
				"title" => esc_html__('General Settings', 'jack-well'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 20,
				"type" => "section",
				),

			'general_layout_info' => array(
				"title" => esc_html__('Layout', 'jack-well'),
				"desc" => '',
				"type" => "info",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'jack-well'),
				"desc" => wp_kses_data( __('Select width of the body content', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'jack-well')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => jack_well_get_list_body_styles(),
				"type" => "select"
				),
			'page_width' => array(
				"title" => esc_html__('Page width', 'jack-well'),
				"desc" => wp_kses_data( __("Total width of the site content and sidebar (in pixels). If empty - use default width", 'jack-well') ),
				"dependency" => array(
					'body_style' => array('boxed', 'wide')
				),
				"std" => 1280,
				"min" => 1000,
				"max" => 1400,
				"step" => 10,
				"refresh" => false,
				"customizer" => 'page',		// SASS name to preview changes 'on fly'
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "slider"
				),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'jack-well') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'jack-well')
				),
				"std" => '',
				"hidden" => true,
				"type" => "image"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'jack-well'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'jack-well')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),

			'general_sidebar_info' => array(
				"title" => esc_html__('Sidebar', 'jack-well'),
				"desc" => '',
				"type" => "info",
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'jack-well'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'jack-well')
				),
				"std" => 'right',
				"options" => array(),
				"type" => "switch"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'jack-well'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'jack-well')
				),
				"dependency" => array(
					'sidebar_position' => array('left', 'right')
				),
				"std" => 'sidebar_widgets',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_width' => array(
				"title" => esc_html__('Sidebar width', 'jack-well'),
				"desc" => wp_kses_data( __("Width of the sidebar (in pixels). If empty - use default width", 'jack-well') ),
				"std" => 370,
				"min" => 150,
				"max" => 500,
				"step" => 5,
				"refresh" => false,
				"customizer" => 'sidebar',		// SASS name to preview changes 'on fly'
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "slider"
				),
			'sidebar_gap' => array(
				"title" => esc_html__('Sidebar gap', 'jack-well'),
				"desc" => wp_kses_data( __("Gap between content and sidebar (in pixels). If empty - use default gap", 'jack-well') ),
				"std" => 40,
				"min" => 0,
				"max" => 110,
				"step" => 1,
				"refresh" => false,
				"customizer" => 'gap',		// SASS name to preview changes 'on fly'
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "slider"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'jack-well'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'jack-well') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),


			'general_widgets_info' => array(
				"title" => esc_html__('Additional widgets', 'jack-well'),
				"desc" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "info",
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets at the top of the page', 'jack-well'),
				"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'jack-well')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'jack-well'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'jack-well')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'jack-well'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'jack-well')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets at the bottom of the page', 'jack-well'),
				"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'jack-well')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
				),

			'general_effects_info' => array(
				"title" => esc_html__('Design & Effects', 'jack-well'),
				"desc" => '',
				"type" => "info",
				),
			'border_radius' => array(
				"title" => esc_html__('Border radius', 'jack-well'),
				"desc" => wp_kses_data( __("Specify the border radius of the form fields and buttons in pixels", 'jack-well') ),
				"std" => 0,
				"min" => 0,
				"max" => 20,
				"step" => 1,
				"refresh" => false,
				"customizer" => 'rad',		// SASS name to preview changes 'on fly'
				"type" => "hidden",
				),

			'general_misc_info' => array(
				"title" => esc_html__('Miscellaneous', 'jack-well'),
				"desc" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "info",
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'jack-well'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'jack-well') ),
				"std" => 0,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'privacy_text' => array(
					"title" => esc_html__("Text with Privacy Policy link", 'jack-well'),
					"desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'jack-well') ),
					"std"   => wp_kses_data( __( 'I agree that my submitted data is being collected and stored.', 'jack-well') ),
					"type"  => "text"
				),
		
		
			// 'Header'
			'header' => array(
				"title" => esc_html__('Header', 'jack-well'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 30,
				"type" => "section"
				),

			'header_style_info' => array(
				"title" => esc_html__('Header style', 'jack-well'),
				"desc" => '',
				"type" => "info"
				),
			'header_type' => array(
				"title" => esc_html__('Header style', 'jack-well'),
				"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well')
				),
				"std" => 'default',
				"options" => jack_well_get_list_header_footer_types(),
				"type" => JACK_WELL_THEME_FREE || !jack_well_exists_trx_addons() ? "hidden" : "switch"
				),
			'header_style' => array(
				"title" => esc_html__('Select custom layout', 'jack-well'),
				"desc" => wp_kses( __("Select custom header from Layouts Builder", 'jack-well'), 'jack_well_kses_content' ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well')
				),
				"dependency" => array(
					'header_type' => array('custom')
				),
				"std" => JACK_WELL_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
				"options" => array(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'jack-well'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well')
				),
				"std" => 'default',
				"options" => array(),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "switch"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Header fullheight', 'jack-well'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well')
				),
				"std" => 0,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_zoom' => array(
				"title" => esc_html__('Header zoom', 'jack-well'),
				"desc" => wp_kses_data( __("Zoom the header title. 1 - original size", 'jack-well') ),
				"std" => 1,
				"min" => 0.3,
				"max" => 2,
				"step" => 0.1,
				"refresh" => false,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "slider"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwidth', 'jack-well'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well')
				),
				"dependency" => array(
					'header_type' => array('default')
				),
				"std" => 1,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_widgets_info' => array(
				"title" => esc_html__('Header widgets', 'jack-well'),
				"desc" => wp_kses_data( __('Here you can place a widget slider, advertising banners, etc.', 'jack-well') ),
				"type" => "info"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'jack-well'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'jack-well') ),
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'jack-well'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well')
				),
				"dependency" => array(
					'header_type' => array('default'),
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => jack_well_get_list_range(0,6),
				"type" => "select"
				),

			'menu_info' => array(
				"title" => esc_html__('Main menu', 'jack-well'),
				"desc" => wp_kses_data( __('Select main menu style, position and other parameters', 'jack-well') ),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'jack-well'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'jack-well')
				),
				"type" => JACK_WELL_THEME_FREE || !jack_well_exists_trx_addons() ? "hidden" : "switch"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'jack-well'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 0,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'jack-well'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'jack-well')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'jack-well'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'jack-well') ),
				"std" => 1,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_image_info' => array(
				"title" => esc_html__('Header image', 'jack-well'),
				"desc" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "info"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'jack-well'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'jack-well') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'jack-well')
				),
				"std" => 0,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_mobile_info' => array(
				"title" => esc_html__('Mobile header', 'jack-well'),
				"desc" => wp_kses_data( __("Configure the mobile version of the header", 'jack-well') ),
				"priority" => 500,
				"dependency" => array(
					'header_type' => array('default')
				),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "info"
				),
			'header_mobile_enabled' => array(
				"title" => esc_html__('Enable the mobile header', 'jack-well'),
				"desc" => wp_kses_data( __("Use the mobile version of the header (if checked) or relayout the current header on mobile devices", 'jack-well') ),
				"dependency" => array(
					'header_type' => array('default')
				),
				"std" => 0,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_additional_info' => array(
				"title" => esc_html__('Additional info', 'jack-well'),
				"desc" => wp_kses_data( __('Additional info to show at the top of the mobile header', 'jack-well') ),
				"std" => '',
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"refresh" => false,
				"teeny" => false,
				"rows" => 20,
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "text_editor"
				),
			'header_mobile_hide_info' => array(
				"title" => esc_html__('Hide additional info', 'jack-well'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_logo' => array(
				"title" => esc_html__('Hide logo', 'jack-well'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_login' => array(
				"title" => esc_html__('Hide login/logout', 'jack-well'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_search' => array(
				"title" => esc_html__('Hide search', 'jack-well'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_cart' => array(
				"title" => esc_html__('Hide cart', 'jack-well'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
				),



			// Section 'Theme Specific'
			'custom_sections_section' => array(
				"title" => esc_html__('Custom Sections (Wide Extra body only)', 'jack-well'),
				"desc" => wp_kses_data( __("Theme specific settings", 'jack-well') ),
				"type" => "section"
			),
			'custom_sections_info' => array(
				"title" => esc_html__('Custom sections', 'jack-well'),
				"desc" => wp_kses_data( __("Custom side sections", 'jack-well') ),
				"type" => "info"
			),
			'custom_sections_1' => array(
				"title" => esc_html__('Show left custom section', 'jack-well'),
				"desc" => wp_kses_data( __("Uncheck this field to hide left section", 'jack-well') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'jack-well')
				),
				"std" => "0",
				"type" => "checkbox"
			),
			'custom_sections_link' => array(
				"title" => esc_html__("Link 1", 'jack-well'),
				"desc" => wp_kses_data( __("Custom Text Link", 'jack-well') ),
				"std" => '',
				"dependency" => array(
					'custom_sections_1' => array('1')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'jack-well')
				),
				"type" => "text"
			),
			'custom_sections_url' => array(
				"title" => esc_html__("URL", 'jack-well'),
				"desc" => wp_kses_data( __("URL for first link", 'jack-well') ),
				"std" => '',
				"dependency" => array(
					'custom_sections_1' => array('1')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'jack-well')
				),
				"type" => "text"
			),
			'custom_sections_2' => array(
				"title" => esc_html__('Show right custom section', 'jack-well'),
				"desc" => wp_kses_data( __("Uncheck this field to hide right section", 'jack-well') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'jack-well')
				),
				"std" => "0",
				"type" => "checkbox"
			),
			'custom_sections_link2' => array(
				"title" => esc_html__("Link 2", 'jack-well'),
				"desc" => wp_kses_data( __("Custom Text Link 2", 'jack-well') ),
				"std" => '',
				"dependency" => array(
					'custom_sections_2' => array('1')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'jack-well')
				),
				"type" => "text"
			),
			'custom_sections_url2' => array(
				"title" => esc_html__("URL", 'jack-well'),
				"desc" => wp_kses_data( __("URL for second link", 'jack-well') ),
				"std" => '',
				"dependency" => array(
					'custom_sections_2' => array('1')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'jack-well')
				),
				"type" => "text"
			),


			// 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'jack-well'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 50,
				"type" => "section"
				),
			'footer_type' => array(
				"title" => esc_html__('Footer style', 'jack-well'),
				"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'jack-well')
				),
				"std" => 'default',
				"options" => jack_well_get_list_header_footer_types(),
				"type" => JACK_WELL_THEME_FREE || !jack_well_exists_trx_addons() ? "hidden" : "switch"
				),
			'footer_style' => array(
				"title" => esc_html__('Select custom layout', 'jack-well'),
				"desc" => wp_kses( __("Select custom footer from Layouts Builder", 'jack-well'), 'jack_well_kses_content' ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'jack-well')
				),
				"dependency" => array(
					'footer_type' => array('custom')
				),
				"std" => JACK_WELL_THEME_FREE ? 'footer-custom-elementor-footer-default' : 'footer-custom-footer-default',
				"options" => array(),
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'jack-well'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'jack-well')
				),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 'footer_widgets',
				"options" => array(),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'jack-well'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'jack-well')
				),
				"dependency" => array(
					'footer_type' => array('default'),
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => jack_well_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwidth', 'jack-well'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'jack-well') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'jack-well')
				),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'jack-well'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'jack-well') ),
				'refresh' => false,
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'jack-well') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1)
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'jack-well') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1),
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'jack-well'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'jack-well') ),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => !jack_well_exists_trx_addons() ? "hidden" : "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'jack-well'),
				"desc" => wp_kses_data( __('Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'jack-well') ),
				"translate" => true,
				"std" => esc_html__('Copyright &copy; {Y} by AncoraThemes. All rights reserved.', 'jack-well'),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"refresh" => false,
				"type" => "textarea"
				),
			
		
		
			// 'Blog'
			'blog' => array(
				"title" => esc_html__('Blog', 'jack-well'),
				"desc" => wp_kses_data( __('Options of the the blog archive', 'jack-well') ),
				"priority" => 70,
				"type" => "panel",
				),
		
				// Blog - Posts page
				'blog_general' => array(
					"title" => esc_html__('Posts page', 'jack-well'),
					"desc" => wp_kses_data( __('Style and components of the blog archive', 'jack-well') ),
					"type" => "section",
					),
				'blog_general_info' => array(
					"title" => esc_html__('General settings', 'jack-well'),
					"desc" => '',
					"type" => "info",
					),
				'blog_style' => array(
					"title" => esc_html__('Blog style', 'jack-well'),
					"desc" => '',
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"std" => 'excerpt',
					"options" => array(),
					"type" => "select"
					),
				'first_post_large' => array(
					"title" => esc_html__('First post large', 'jack-well'),
					"desc" => wp_kses_data( __('Make your first post stand out by making it bigger', 'jack-well') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style' => array('classic', 'masonry')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				"blog_content" => array( 
					"title" => esc_html__('Posts content', 'jack-well'),
					"desc" => wp_kses_data( __("Display either post excerpts or the full post content", 'jack-well') ),
					"std" => "excerpt",
					"dependency" => array(
						'blog_style' => array('excerpt')
					),
					"options" => array(
						'excerpt'	=> esc_html__('Excerpt',	'jack-well'),
						'fullpost'	=> esc_html__('Full post',	'jack-well')
					),
					"type" => "switch"
					),
				'excerpt_length' => array(
					"title" => esc_html__('Excerpt length', 'jack-well'),
					"desc" => wp_kses_data( __("Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged", 'jack-well') ),
					"dependency" => array(
						'blog_style' => array('excerpt'),
						'blog_content' => array('excerpt')
					),
					"std" => 60,
					"type" => "text"
					),
				'blog_columns' => array(
					"title" => esc_html__('Blog columns', 'jack-well'),
					"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'jack-well') ),
					"std" => 2,
					"options" => jack_well_get_list_range(2,4),
					"type" => "hidden"
					),
				'post_type' => array(
					"title" => esc_html__('Post type', 'jack-well'),
					"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'jack-well') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"linked" => 'parent_cat',
					"refresh" => false,
					"hidden" => true,
					"std" => 'post',
					"options" => array(),
					"type" => "select"
					),
				'parent_cat' => array(
					"title" => esc_html__('Category to show', 'jack-well'),
					"desc" => wp_kses_data( __('Select category to show in the blog archive', 'jack-well') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"refresh" => false,
					"hidden" => true,
					"std" => '0',
					"options" => array(),
					"type" => "select"
					),
				'posts_per_page' => array(
					"title" => esc_html__('Posts per page', 'jack-well'),
					"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'jack-well') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"hidden" => true,
					"std" => '',
					"type" => "text"
					),
				"blog_pagination" => array( 
					"title" => esc_html__('Pagination style', 'jack-well'),
					"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'jack-well') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"std" => "pages",
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"options" => array(
						'pages'	=> esc_html__("Page numbers", 'jack-well'),
						'links'	=> esc_html__("Older/Newest", 'jack-well'),
						'more'	=> esc_html__("Load more", 'jack-well'),
						'infinite' => esc_html__("Infinite scroll", 'jack-well')
					),
					"type" => "select"
					),
				'show_filters' => array(
					"title" => esc_html__('Show filters', 'jack-well'),
					"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'jack-well') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style' => array('portfolio', 'gallery')
					),
					"hidden" => true,
					"std" => 0,
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "checkbox"
					),
	
				'blog_sidebar_info' => array(
					"title" => esc_html__('Sidebar', 'jack-well'),
					"desc" => '',
					"type" => "info",
					),
				'sidebar_position_blog' => array(
					"title" => esc_html__('Sidebar position', 'jack-well'),
					"desc" => wp_kses_data( __('Select position to show sidebar', 'jack-well') ),
					"std" => 'right',
					"options" => array(),
					"type" => "switch"
					),
				'sidebar_widgets_blog' => array(
					"title" => esc_html__('Sidebar widgets', 'jack-well'),
					"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'jack-well') ),
					"dependency" => array(
						'sidebar_position_blog' => array('left', 'right')
					),
					"std" => 'sidebar_widgets',
					"options" => array(),
					"type" => "select"
					),
				'expand_content_blog' => array(
					"title" => esc_html__('Expand content', 'jack-well'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'jack-well') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
	
	
				'blog_widgets_info' => array(
					"title" => esc_html__('Additional widgets', 'jack-well'),
					"desc" => '',
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "info",
					),
				'widgets_above_page_blog' => array(
					"title" => esc_html__('Widgets at the top of the page', 'jack-well'),
					"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'jack-well') ),
					"std" => 'hide',
					"options" => array(),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
					),
				'widgets_above_content_blog' => array(
					"title" => esc_html__('Widgets above the content', 'jack-well'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'jack-well') ),
					"std" => 'hide',
					"options" => array(),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_content_blog' => array(
					"title" => esc_html__('Widgets below the content', 'jack-well'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'jack-well') ),
					"std" => 'hide',
					"options" => array(),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_page_blog' => array(
					"title" => esc_html__('Widgets at the bottom of the page', 'jack-well'),
					"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'jack-well') ),
					"std" => 'hide',
					"options" => array(),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
					),

				'blog_advanced_info' => array(
					"title" => esc_html__('Advanced settings', 'jack-well'),
					"desc" => '',
					"type" => "info",
					),
				'no_image' => array(
					"title" => esc_html__('Image placeholder', 'jack-well'),
					"desc" => wp_kses_data( __('Select or upload an image used as placeholder for posts without a featured image', 'jack-well') ),
					"std" => '',
					"type" => "image"
					),
				'time_diff_before' => array(
					"title" => esc_html__('Easy Readable Date Format', 'jack-well'),
					"desc" => wp_kses_data( __("For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'jack-well') ),
					"std" => 5,
					"type" => "text"
					),
				'sticky_style' => array(
					"title" => esc_html__('Sticky posts style', 'jack-well'),
					"desc" => wp_kses_data( __('Select style of the sticky posts output', 'jack-well') ),
					"std" => 'inherit',
					"options" => array(
						'inherit' => esc_html__('Decorated posts', 'jack-well'),
						'columns' => esc_html__('Mini-cards',	'jack-well')
					),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
					),
				"blog_animation" => array( 
					"title" => esc_html__('Animation for the posts', 'jack-well'),
					"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'jack-well') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"std" => "none",
					"options" => array(),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
					),
				'meta_parts' => array(
					"title" => esc_html__('Post meta', 'jack-well'),
					"desc" => wp_kses_data( __("If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page. Counters and Share Links are available only if plugin ThemeREX Addons is active", 'jack-well') )
								. '<br>'
								. wp_kses_data( __("<b>Tip:</b> Drag items to change their order.", 'jack-well') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=1|date=1|counters=1|author=1|share=0|edit=0',
					"options" => array(
						'categories' => esc_html__('Categories', 'jack-well'),
						'date'		 => esc_html__('Post date', 'jack-well'),
						'author'	 => esc_html__('Post author', 'jack-well'),
						'counters'	 => esc_html__('Views, Likes and Comments', 'jack-well'),
						'share'		 => esc_html__('Share links', 'jack-well'),
						'edit'		 => esc_html__('Edit link', 'jack-well')
					),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "checklist"
				),
				'counters' => array(
					"title" => esc_html__('Views, Likes and Comments', 'jack-well'),
					"desc" => wp_kses_data( __("Likes and Views are available only if ThemeREX Addons is active", 'jack-well') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'jack-well')
					),
					"dependency" => array(
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=0|likes=0|comments=1',
					"options" => array(
						'views' => esc_html__('Views', 'jack-well'),
						'likes' => esc_html__('Likes', 'jack-well'),
						'comments' => esc_html__('Comments', 'jack-well')
					),
					"type" => JACK_WELL_THEME_FREE || !jack_well_exists_trx_addons() ? "hidden" : "checklist"
				),

				
				// Blog - Single posts
				'blog_single' => array(
					"title" => esc_html__('Single posts', 'jack-well'),
					"desc" => wp_kses_data( __('Settings of the single post', 'jack-well') ),
					"type" => "section",
					),
				'hide_featured_on_single' => array(
					"title" => esc_html__('Hide featured image on the single post', 'jack-well'),
					"desc" => wp_kses_data( __("Hide featured image on the single post's pages", 'jack-well') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'jack-well')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				'hide_sidebar_on_single' => array(
					"title" => esc_html__('Hide sidebar on the single post', 'jack-well'),
					"desc" => wp_kses_data( __("Hide sidebar on the single post's pages", 'jack-well') ),
					"std" => 0,
					"type" => "checkbox"
					),
				'show_post_meta' => array(
					"title" => esc_html__('Show post meta', 'jack-well'),
					"desc" => wp_kses_data( __("Display block with post's meta: date, categories, counters, etc.", 'jack-well') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'meta_parts_post' => array(
					"title" => esc_html__('Post meta', 'jack-well'),
					"desc" => wp_kses_data( __("Meta parts for single posts. Counters and Share Links are available only if plugin ThemeREX Addons is active", 'jack-well') )
								. '<br>'
								. wp_kses_data( __("<b>Tip:</b> Drag items to change their order.", 'jack-well') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=1|date=1|counters=0|author=1|share=0|edit=0',
					"options" => array(
						'categories' => esc_html__('Categories', 'jack-well'),
						'date'		 => esc_html__('Post date', 'jack-well'),
						'author'	 => esc_html__('Post author', 'jack-well'),
						'counters'	 => esc_html__('Views, Likes and Comments', 'jack-well'),
						'share'		 => esc_html__('Share links', 'jack-well'),
						'edit'		 => esc_html__('Edit link', 'jack-well')
					),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "checklist"
				),
				'counters_post' => array(
					"title" => esc_html__('Views, Likes and Comments', 'jack-well'),
					"desc" => wp_kses_data( __("Likes and Views are available only if plugin ThemeREX Addons is active", 'jack-well') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=1|likes=1|comments=1',
					"options" => array(
						'views' => esc_html__('Views', 'jack-well'),
						'likes' => esc_html__('Likes', 'jack-well'),
						'comments' => esc_html__('Comments', 'jack-well')
					),
					"type" => JACK_WELL_THEME_FREE || !jack_well_exists_trx_addons() ? "hidden" : "checklist"
				),
				'show_share_links' => array(
					"title" => esc_html__('Show share links', 'jack-well'),
					"desc" => wp_kses_data( __("Display share links on the single post", 'jack-well') ),
					"std" => 1,
					"type" => !jack_well_exists_trx_addons() ? "hidden" : "checkbox"
					),
				'show_author_info' => array(
					"title" => esc_html__('Show author info', 'jack-well'),
					"desc" => wp_kses_data( __("Display block with information about post's author", 'jack-well') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'blog_single_related_info' => array(
					"title" => esc_html__('Related posts', 'jack-well'),
					"desc" => '',
					"type" => "info",
					),
				'show_related_posts' => array(
					"title" => esc_html__('Show related posts', 'jack-well'),
					"desc" => wp_kses_data( __("Show section 'Related posts' on the single post's pages", 'jack-well') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'jack-well')
					),
					"std" => 1,
					"type" => "checkbox"
					),
				'related_posts' => array(
					"title" => esc_html__('Related posts', 'jack-well'),
					"desc" => wp_kses_data( __('How many related posts should be displayed in the single post? If 0 - no related posts are shown.', 'jack-well') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => jack_well_get_list_range(1,9),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
					),
				'related_columns' => array(
					"title" => esc_html__('Related columns', 'jack-well'),
					"desc" => wp_kses_data( __('How many columns should be used to output related posts in the single page?', 'jack-well') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 1,
					"options" => jack_well_get_list_range(1,1),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "switch"
					),
				'related_style' => array(
					"title" => esc_html__('Related posts style', 'jack-well'),
					"desc" => wp_kses_data( __('Select style of the related posts output', 'jack-well') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 1,
					"options" => jack_well_get_list_styles(1,1),
					"type" => JACK_WELL_THEME_FREE ? "hidden" : "switch"
					),
			'blog_end' => array(
				"type" => "panel_end",
				),
			
		
		
			// 'Colors'
			'panel_colors' => array(
				"title" => esc_html__('Colors', 'jack-well'),
				"desc" => '',
				"priority" => 300,
				"type" => "section"
				),

			'color_schemes_info' => array(
				"title" => esc_html__('Color schemes', 'jack-well'),
				"desc" => wp_kses_data( __('Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'jack-well') ),
				"hidden" => $hide_schemes,
				"type" => "info",
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'jack-well'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'jack-well')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => $hide_schemes ? 'hidden' : "switch"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'jack-well'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'jack-well')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => $hide_schemes ? 'hidden' : "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Sidemenu Color Scheme', 'jack-well'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'jack-well')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => 'hidden'
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Sidebar Color Scheme', 'jack-well'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'jack-well')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => $hide_schemes ? 'hidden' : "switch"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'jack-well'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'jack-well')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => $hide_schemes ? 'hidden' : "switch"
				),

			'color_scheme_editor_info' => array(
				"title" => esc_html__('Color scheme editor', 'jack-well'),
				"desc" => wp_kses_data(__('Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'jack-well') ),
				"type" => "info",
				),
			'scheme_storage' => array(
				"title" => esc_html__('Color scheme editor', 'jack-well'),
				"desc" => '',
				"std" => '$jack_well_get_scheme_storage',
				"refresh" => false,
				"colorpicker" => "tiny",
				"type" => "scheme_editor"
				),


			// 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'jack-well'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'jack-well') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'jack-well')
				),
				"hidden" => true,
				"std" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'jack-well'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'jack-well') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'jack-well')
				),
				"hidden" => true,
				"std" => '',
				"type" => JACK_WELL_THEME_FREE ? "hidden" : "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			// Use huge priority to call render this elements after all options!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"priority" => 10000,
				"type" => "hidden",
				),

			'last_option' => array(		// Need to manually call action to include Tiny MCE scripts
				"title" => '',
				"desc" => '',
				"std" => 1,
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		// -------------------------------------------------------------
		$fonts = array(
		
			// 'Fonts'
			'fonts' => array(
				"title" => esc_html__('Typography', 'jack-well'),
				"desc" => '',
				"priority" => 200,
				"type" => "panel"
				),

			// Fonts - Load_fonts
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'jack-well'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'jack-well') )
						. '<br>'
						. wp_kses_data( __('Attention! Press "Refresh" button to reload preview area after the all fonts are changed', 'jack-well') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'jack-well'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'jack-well') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'jack-well') ),
				"class" => "jack_well_column-1_3 jack_well_new_row",
				"refresh" => false,
				"std" => '$jack_well_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=jack_well_get_theme_setting('max_load_fonts'); $i++) {
			if (jack_well_get_value_gp('page') != 'theme_options') {
				$fonts["load_fonts-{$i}-info"] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					"title" => esc_html(sprintf(__('Font %s', 'jack-well'), $i)),
					"desc" => '',
					"type" => "info",
					);
			}
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'jack-well'),
				"desc" => '',
				"class" => "jack_well_column-1_3 jack_well_new_row",
				"refresh" => false,
				"std" => '$jack_well_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'jack-well'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'jack-well') )
							: '',
				"class" => "jack_well_column-1_3",
				"refresh" => false,
				"std" => '$jack_well_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'jack-well'),
					'serif' => esc_html__('serif', 'jack-well'),
					'sans-serif' => esc_html__('sans-serif', 'jack-well'),
					'monospace' => esc_html__('monospace', 'jack-well'),
					'cursive' => esc_html__('cursive', 'jack-well'),
					'fantasy' => esc_html__('fantasy', 'jack-well')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'jack-well'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'jack-well') )
								. '<br>'
								. wp_kses_data( __('Attention! Each weight and style increase download size! Specify only used weights and styles.', 'jack-well') )
							: '',
				"class" => "jack_well_column-1_3",
				"refresh" => false,
				"std" => '$jack_well_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = jack_well_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html(sprintf(__('%s settings', 'jack-well'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								// Translators: Add tag's name to make description
								: wp_kses_post( sprintf(__('Font settings of the "%s" tag.', 'jack-well'), $tag) ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$load_order = 1;
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = array();
					$load_order = 2;		// Load this option's value after all options are loaded (use option 'load_fonts' to build fonts list)
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'jack-well'),
						'100' => esc_html__('100 (Light)', 'jack-well'), 
						'200' => esc_html__('200 (Light)', 'jack-well'), 
						'300' => esc_html__('300 (Thin)',  'jack-well'),
						'400' => esc_html__('400 (Normal)', 'jack-well'),
						'500' => esc_html__('500 (Semibold)', 'jack-well'),
						'600' => esc_html__('600 (Semibold)', 'jack-well'),
						'700' => esc_html__('700 (Bold)', 'jack-well'),
						'800' => esc_html__('800 (Black)', 'jack-well'),
						'900' => esc_html__('900 (Black)', 'jack-well')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'jack-well'),
						'normal' => esc_html__('Normal', 'jack-well'), 
						'italic' => esc_html__('Italic', 'jack-well')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'jack-well'),
						'none' => esc_html__('None', 'jack-well'), 
						'underline' => esc_html__('Underline', 'jack-well'),
						'overline' => esc_html__('Overline', 'jack-well'),
						'line-through' => esc_html__('Line-through', 'jack-well')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'jack-well'),
						'none' => esc_html__('None', 'jack-well'), 
						'uppercase' => esc_html__('Uppercase', 'jack-well'),
						'lowercase' => esc_html__('Lowercase', 'jack-well'),
						'capitalize' => esc_html__('Capitalize', 'jack-well')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"class" => "jack_well_column-1_5",
					"refresh" => false,
					"load_order" => $load_order,
					"std" => '$jack_well_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters to Theme Options
		jack_well_storage_set_array_before('options', 'panel_colors', $fonts);


		// Add Header Video if WP version < 4.7
		// -----------------------------------------------------
		if (!function_exists('get_header_video_url')) {
			jack_well_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'jack-well'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'jack-well') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'jack-well')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}


		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is 'Theme Options'
		// ------------------------------------------------------
		if (!function_exists('the_custom_logo') || (isset($_REQUEST['page']) && $_REQUEST['page']=='theme_options')) {
			jack_well_storage_set_array_before('options', 'logo_retina', function_exists('the_custom_logo') ? 'custom_logo' : 'logo', array(
				"title" => esc_html__('Logo', 'jack-well'),
				"desc" => wp_kses_data( __('Select or upload the site logo', 'jack-well') ),
				"class" => "jack_well_column-1_2 jack_well_new_row",
				"priority" => 60,
				"std" => '',
				"type" => "image"
				)
			);
		}

	}
}


// Returns a list of options that can be overridden for CPT
if (!function_exists('jack_well_options_get_list_cpt_options')) {
	function jack_well_options_get_list_cpt_options($cpt, $title='') {
		if (empty($title)) $title = ucfirst($cpt);
		return array(
					"header_info_{$cpt}" => array(
						"title" => esc_html__('Header', 'jack-well'),
						"desc" => '',
						"type" => "info",
						),
					"header_type_{$cpt}" => array(
						"title" => esc_html__('Header style', 'jack-well'),
						"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'jack-well') ),
						"std" => 'inherit',
						"options" => jack_well_get_list_header_footer_types(true),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "switch"
						),
					"header_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'jack-well'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select custom layout to display the site header on the %s pages', 'jack-well'), $title) ),
						"dependency" => array(
							"header_type_{$cpt}" => array('custom')
						),
						"std" => 'inherit',
						"options" => array(),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
						),
					"header_position_{$cpt}" => array(
						"title" => esc_html__('Header position', 'jack-well'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to display the site header on the %s pages', 'jack-well'), $title) ),
						"std" => 'inherit',
						"options" => array(),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "switch"
						),
					"header_image_override_{$cpt}" => array(
						"title" => esc_html__('Header image override', 'jack-well'),
						"desc" => wp_kses_data( __("Allow override the header image with the post's featured image", 'jack-well') ),
						"std" => 'inherit',
						"options" => array(
							'inherit' => esc_html__('Inherit', 'jack-well'),
							1 => esc_html__('Yes', 'jack-well'),
							0 => esc_html__('No', 'jack-well'),
						),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "switch"
						),
					"header_widgets_{$cpt}" => array(
						"title" => esc_html__('Header widgets', 'jack-well'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select set of widgets to show in the header on the %s pages', 'jack-well'), $title) ),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
						
					"sidebar_info_{$cpt}" => array(
						"title" => esc_html__('Sidebar', 'jack-well'),
						"desc" => '',
						"type" => "info",
						),
					"sidebar_position_{$cpt}" => array(
						"title" => esc_html__('Sidebar position', 'jack-well'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to show sidebar on the %s pages', 'jack-well'), $title) ),
						"std" => 'left',
						"options" => array(),
						"type" => "switch"
						),
					"sidebar_widgets_{$cpt}" => array(
						"title" => esc_html__('Sidebar widgets', 'jack-well'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select sidebar to show on the %s pages', 'jack-well'), $title) ),
						"dependency" => array(
							"sidebar_position_{$cpt}" => array('left', 'right')
						),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
					"hide_sidebar_on_single_{$cpt}" => array(
						"title" => esc_html__('Hide sidebar on the single pages', 'jack-well'),
						"desc" => wp_kses_data( __("Hide sidebar on the single page", 'jack-well') ),
						"std" => 'inherit',
						"options" => array(
							'inherit' => esc_html__('Inherit', 'jack-well'),
							1 => esc_html__('Hide', 'jack-well'),
							0 => esc_html__('Show', 'jack-well'),
						),
						"type" => "switch"
						),
						
					"footer_info_{$cpt}" => array(
						"title" => esc_html__('Footer', 'jack-well'),
						"desc" => '',
						"type" => "info",
						),
					"footer_type_{$cpt}" => array(
						"title" => esc_html__('Footer style', 'jack-well'),
						"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'jack-well') ),
						"std" => 'inherit',
						"options" => jack_well_get_list_header_footer_types(true),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "switch"
						),
					"footer_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'jack-well'),
						"desc" => wp_kses_data( __('Select custom layout to display the site footer', 'jack-well') ),
						"std" => 'inherit',
						"dependency" => array(
							"footer_type_{$cpt}" => array('custom')
						),
						"options" => array(),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
						),
					"footer_widgets_{$cpt}" => array(
						"title" => esc_html__('Footer widgets', 'jack-well'),
						"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'jack-well') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 'footer_widgets',
						"options" => array(),
						"type" => "select"
						),
					"footer_columns_{$cpt}" => array(
						"title" => esc_html__('Footer columns', 'jack-well'),
						"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'jack-well') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default'),
							"footer_widgets_{$cpt}" => array('^hide')
						),
						"std" => 0,
						"options" => jack_well_get_list_range(0,6),
						"type" => "select"
						),
					"footer_wide_{$cpt}" => array(
						"title" => esc_html__('Footer fullwidth', 'jack-well'),
						"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'jack-well') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"widgets_info_{$cpt}" => array(
						"title" => esc_html__('Additional panels', 'jack-well'),
						"desc" => '',
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "info",
						),
					"widgets_above_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the top of the page', 'jack-well'),
						"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'jack-well') ),
						"std" => 'hide',
						"options" => array(),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
						),
					"widgets_above_content_{$cpt}" => array(
						"title" => esc_html__('Widgets above the content', 'jack-well'),
						"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'jack-well') ),
						"std" => 'hide',
						"options" => array(),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_content_{$cpt}" => array(
						"title" => esc_html__('Widgets below the content', 'jack-well'),
						"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'jack-well') ),
						"std" => 'hide',
						"options" => array(),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the bottom of the page', 'jack-well'),
						"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'jack-well') ),
						"std" => 'hide',
						"options" => array(),
						"type" => JACK_WELL_THEME_FREE ? "hidden" : "select"
						)
					);
	}
}


// Return lists with choises when its need in the admin mode
if (!function_exists('jack_well_options_get_list_choises')) {
	add_filter('jack_well_filter_options_get_list_choises', 'jack_well_options_get_list_choises', 10, 2);
	function jack_well_options_get_list_choises($list, $id) {
		if (is_array($list) && count($list)==0) {
			if (strpos($id, 'header_style')===0)
				$list = jack_well_get_list_header_styles(strpos($id, 'header_style_')===0);
			else if (strpos($id, 'header_position')===0)
				$list = jack_well_get_list_header_positions(strpos($id, 'header_position_')===0);
			else if (strpos($id, 'header_widgets')===0)
				$list = jack_well_get_list_sidebars(strpos($id, 'header_widgets_')===0, true);
			else if (strpos($id, '_scheme') > 0)
				$list = jack_well_get_list_schemes($id!='color_scheme');
			else if (strpos($id, 'sidebar_widgets')===0)
				$list = jack_well_get_list_sidebars(strpos($id, 'sidebar_widgets_')===0, true);
			else if (strpos($id, 'sidebar_position')===0)
				$list = jack_well_get_list_sidebars_positions(strpos($id, 'sidebar_position_')===0);
			else if (strpos($id, 'widgets_above_page')===0)
				$list = jack_well_get_list_sidebars(strpos($id, 'widgets_above_page_')===0, true);
			else if (strpos($id, 'widgets_above_content')===0)
				$list = jack_well_get_list_sidebars(strpos($id, 'widgets_above_content_')===0, true);
			else if (strpos($id, 'widgets_below_page')===0)
				$list = jack_well_get_list_sidebars(strpos($id, 'widgets_below_page_')===0, true);
			else if (strpos($id, 'widgets_below_content')===0)
				$list = jack_well_get_list_sidebars(strpos($id, 'widgets_below_content_')===0, true);
			else if (strpos($id, 'footer_style')===0)
				$list = jack_well_get_list_footer_styles(strpos($id, 'footer_style_')===0);
			else if (strpos($id, 'footer_widgets')===0)
				$list = jack_well_get_list_sidebars(strpos($id, 'footer_widgets_')===0, true);
			else if (strpos($id, 'blog_style')===0)
				$list = jack_well_get_list_blog_styles(strpos($id, 'blog_style_')===0);
			else if (strpos($id, 'post_type')===0)
				$list = jack_well_get_list_posts_types();
			else if (strpos($id, 'parent_cat')===0)
				$list = jack_well_array_merge(array(0 => esc_html__('- Select category -', 'jack-well')), jack_well_get_list_categories());
			else if (strpos($id, 'blog_animation')===0)
				$list = jack_well_get_list_animations_in();
			else if ($id == 'color_scheme_editor')
				$list = jack_well_get_list_schemes();
			else if (strpos($id, '_font-family') > 0)
				$list = jack_well_get_list_load_fonts(true);
		}
		return $list;
	}
}
?>