<?php
/**
 * The template 'Style 2' to displaying related posts
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_link = get_permalink();
$jack_well_post_format = get_post_format();
$jack_well_post_format = empty($jack_well_post_format) ? 'standard' : str_replace('post-format-', '', $jack_well_post_format);




?><div id="post-<?php the_ID(); ?>" 
	<?php post_class( 'related_item related_item_style_2 post_format_'.esc_attr($jack_well_post_format) ); ?>><?php






	jack_well_show_post_featured(array(
		'thumb_size' => apply_filters('jack_well_filter_related_thumb_size', jack_well_get_thumb_size( (int) jack_well_get_theme_option('related_posts') == 1 ? 'huge' : 'big' )),
		'show_no_image' => jack_well_get_theme_setting('allow_no_image'),
		'singular' => false
		)
	);



	?><div class="post_header entry-header"><?php
		if ( in_array(get_post_type(), array( 'post', 'attachment' ) ) ) {
			?><span class="post_date"><a href="<?php echo esc_url($jack_well_link); ?>"><?php echo wp_kses_data(jack_well_get_date()); ?></a></span><?php
		}
		?>
		<h6 class="post_title entry-title"><a href="<?php echo esc_url($jack_well_link); ?>"><?php the_title(); ?></a></h6>
	</div>
</div>