<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

// Header sidebar
$jack_well_header_name = jack_well_get_theme_option('header_widgets');
$jack_well_header_present = !jack_well_is_off($jack_well_header_name) && is_active_sidebar($jack_well_header_name);
if ($jack_well_header_present) { 
	jack_well_storage_set('current_sidebar', 'header');
	$jack_well_header_wide = jack_well_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($jack_well_header_name) ) {
		dynamic_sidebar($jack_well_header_name);
	}
	$jack_well_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($jack_well_widgets_output)) {
		$jack_well_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $jack_well_widgets_output);
		$jack_well_need_columns = strpos($jack_well_widgets_output, 'columns_wrap')===false;
		if ($jack_well_need_columns) {
			$jack_well_columns = max(0, (int) jack_well_get_theme_option('header_columns'));
			if ($jack_well_columns == 0) $jack_well_columns = min(6, max(1, substr_count($jack_well_widgets_output, '<aside ')));
			if ($jack_well_columns > 1)
				$jack_well_widgets_output = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($jack_well_columns).' widget', $jack_well_widgets_output);
			else
				$jack_well_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($jack_well_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$jack_well_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($jack_well_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'jack_well_action_before_sidebar' );
				jack_well_show_layout($jack_well_widgets_output);
				do_action( 'jack_well_action_after_sidebar' );
				if ($jack_well_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$jack_well_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>