<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_header_css = '';
$jack_well_header_image = get_header_image();
$jack_well_header_video = jack_well_get_header_video();
if (!empty($jack_well_header_image) && jack_well_trx_addons_featured_image_override(is_singular() || jack_well_storage_isset('blog_archive') || is_category())) {
	$jack_well_header_image = jack_well_get_current_mode_image($jack_well_header_image);
}

?><header class="top_panel top_panel_default<?php
					echo !empty($jack_well_header_image) || !empty($jack_well_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($jack_well_header_video!='') echo ' with_bg_video';
					if ($jack_well_header_image!='') echo ' '.esc_attr(jack_well_add_inline_css_class('background-image: url('.esc_url($jack_well_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (jack_well_is_on(jack_well_get_theme_option('header_fullheight'))) echo ' header_fullheight jack_well-full-height';
					if (!jack_well_is_inherit(jack_well_get_theme_option('header_scheme')))
						echo ' scheme_' . esc_attr(jack_well_get_theme_option('header_scheme'));
					?>"><?php

	// Background video
	if (!empty($jack_well_header_video)) {
		get_template_part( 'templates/header-video' );
	}
	
	// Main menu
	if (jack_well_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Mobile header
	if (jack_well_is_on(jack_well_get_theme_option("header_mobile_enabled"))) {
		get_template_part( 'templates/header-mobile' );
	}
	
	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

	// Display featured image in the header on the single posts
	// Comment next line to prevent show featured image in the header area
	// and display it in the post's content
	if (false) {
		get_template_part( 'templates/header-single' );
	}

?></header>