<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0.06
 */

$jack_well_header_css = '';
$jack_well_header_image = get_header_image();
$jack_well_header_video = jack_well_get_header_video();
if (!empty($jack_well_header_image) && jack_well_trx_addons_featured_image_override(is_singular() || jack_well_storage_isset('blog_archive') || is_category())) {
	$jack_well_header_image = jack_well_get_current_mode_image($jack_well_header_image);
}
$jack_well_header_id = str_replace('header-custom-', '', jack_well_get_theme_option("header_style"));
if ((int) $jack_well_header_id == 0) {
	$jack_well_header_id = jack_well_get_post_id(array(
												'name' => $jack_well_header_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$jack_well_header_id = apply_filters('jack_well_filter_get_translated_layout', $jack_well_header_id);
}
$jack_well_header_meta = get_post_meta($jack_well_header_id, 'trx_addons_options', true);
if (!empty($jack_well_header_meta['margin']) != '') 
	jack_well_add_inline_css(sprintf('.page_content_wrap{padding-top:%s}', esc_attr(jack_well_prepare_css_value($jack_well_header_meta['margin']))));

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($jack_well_header_id); 
				?> top_panel_custom_<?php echo esc_attr(sanitize_title(get_the_title($jack_well_header_id)));
				echo !empty($jack_well_header_image) || !empty($jack_well_header_video) 
					? ' with_bg_image' 
					: ' without_bg_image';
				if ($jack_well_header_video!='') 
					echo ' with_bg_video';
				if ($jack_well_header_image!='') 
					echo ' '.esc_attr(jack_well_add_inline_css_class('background-image: url('.esc_url($jack_well_header_image).');'));
				if (is_single() && has_post_thumbnail()) 
					echo ' with_featured_image';
				if (jack_well_is_on(jack_well_get_theme_option('header_fullheight'))) 
					echo ' header_fullheight jack_well-full-height';
				if (!jack_well_is_inherit(jack_well_get_theme_option('header_scheme')))
					echo ' scheme_' . esc_attr(jack_well_get_theme_option('header_scheme'));
				?>"><?php

	// Background video
	if (!empty($jack_well_header_video)) {
		get_template_part( 'templates/header-video' );
	}
		
	// Custom header's layout
	do_action('jack_well_action_show_layout', $jack_well_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );
		
?></header>