<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0.10
 */

// Footer sidebar
$jack_well_footer_name = jack_well_get_theme_option('footer_widgets');
$jack_well_footer_present = !jack_well_is_off($jack_well_footer_name) && is_active_sidebar($jack_well_footer_name);
if ($jack_well_footer_present) { 
	jack_well_storage_set('current_sidebar', 'footer');
	$jack_well_footer_wide = jack_well_get_theme_option('footer_wide');
	ob_start();
	if ( is_active_sidebar($jack_well_footer_name) ) {
		dynamic_sidebar($jack_well_footer_name);
	}
	$jack_well_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($jack_well_out)) {
		$jack_well_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $jack_well_out);
		$jack_well_need_columns = true;	//or check: strpos($jack_well_out, 'columns_wrap')===false;
		if ($jack_well_need_columns) {
			$jack_well_columns = max(0, (int) jack_well_get_theme_option('footer_columns'));
			if ($jack_well_columns == 0) $jack_well_columns = min(4, max(1, substr_count($jack_well_out, '<aside ')));
			if ($jack_well_columns > 1)
				$jack_well_out = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($jack_well_columns).' widget', $jack_well_out);
			else
				$jack_well_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($jack_well_footer_wide) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$jack_well_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($jack_well_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'jack_well_action_before_sidebar' );
				jack_well_show_layout($jack_well_out);
				do_action( 'jack_well_action_after_sidebar' );
				if ($jack_well_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$jack_well_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>