<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0.10
 */

// Logo
if (jack_well_is_on(jack_well_get_theme_option('logo_in_footer'))) {
	$jack_well_logo_image = '';
	if (jack_well_is_on(jack_well_get_theme_option('logo_retina_enabled')) && jack_well_get_retina_multiplier() > 1)
		$jack_well_logo_image = jack_well_get_theme_option( 'logo_footer_retina' );
	if (empty($jack_well_logo_image)) 
		$jack_well_logo_image = jack_well_get_theme_option( 'logo_footer' );
	$jack_well_logo_text   = get_bloginfo( 'name' );
	if (!empty($jack_well_logo_image) || !empty($jack_well_logo_text)) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if (!empty($jack_well_logo_image)) {
					$jack_well_attr = jack_well_getimagesize($jack_well_logo_image);
					$alt_title = esc_html__('logo-footer-image', 'jack-well');
					echo '<a href="'.esc_url(home_url('/')).'"><img src="'.esc_url($jack_well_logo_image).'" class="logo_footer_image" alt="'.esc_attr($alt_title).'"'.(!empty($jack_well_attr[3]) ? ' ' . wp_kses_data($jack_well_attr[3]) : '').'></a>' ;
				} else if (!empty($jack_well_logo_text)) {
					echo '<h1 class="logo_footer_text"><a href="'.esc_url(home_url('/')).'">' . esc_html($jack_well_logo_text) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>