<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0.10
 */

$jack_well_footer_id = str_replace('footer-custom-', '', jack_well_get_theme_option("footer_style"));
if ((int) $jack_well_footer_id == 0) {
	$jack_well_footer_id = jack_well_get_post_id(array(
												'name' => $jack_well_footer_id,
												'post_type' => defined('TRX_ADDONS_CPT_LAYOUTS_PT') ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts'
												)
											);
} else {
	$jack_well_footer_id = apply_filters('jack_well_filter_get_translated_layout', $jack_well_footer_id);
}
$jack_well_footer_meta = get_post_meta($jack_well_footer_id, 'trx_addons_options', true);
if (!empty($jack_well_footer_meta['margin']) != '') 
	jack_well_add_inline_css(sprintf('.page_content_wrap{padding-bottom:%s}', esc_attr(jack_well_prepare_css_value($jack_well_footer_meta['margin']))));
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr($jack_well_footer_id); 
						?> footer_custom_<?php echo esc_attr(sanitize_title(get_the_title($jack_well_footer_id))); 
						if (!jack_well_is_inherit(jack_well_get_theme_option('footer_scheme')))
							echo ' scheme_' . esc_attr(jack_well_get_theme_option('footer_scheme'));
						?>">
	<?php
    // Custom footer's layout
    do_action('jack_well_action_show_layout', $jack_well_footer_id);
	?>
</footer><!-- /.footer_wrap -->
