<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */
?>

<div class="author_info scheme_default author vcard" itemprop="author" itemscope itemtype="//schema.org/Person">

	<div class="author_avatar" itemprop="image">
		<?php 
		$jack_well_mult = jack_well_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 120*$jack_well_mult );
		?>
	</div><!-- .author_avatar -->

	<div class="author_description">
		<div class="author_description_text"> <?php esc_html_e('About author', 'jack-well'); ?>
	</div>
		<h5 class="author_title" itemprop="name">
			<a class="author_link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author"><?php
				// Translators: Add the author's name in the <span>
				printf('<span class="author_name">' . esc_html(get_the_author()) . '</span>' );
			?></a>
		</h5>

		<div class="author_bio" itemprop="description">
			<?php echo wp_kses(wpautop(get_the_author_meta( 'description' )), 'jack_well_kses_content' ); ?>

			<?php do_action('jack_well_action_user_meta'); ?>
		</div><!-- .author_bio -->

	</div><!-- .author_description -->

</div><!-- .author_info -->
