<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

if (jack_well_sidebar_present()) {
	ob_start();
	$jack_well_sidebar_name = jack_well_get_theme_option('sidebar_widgets');
	jack_well_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar($jack_well_sidebar_name) ) {
		dynamic_sidebar($jack_well_sidebar_name);
	}
	$jack_well_out = trim(ob_get_contents());
	ob_end_clean();
	if (!empty($jack_well_out)) {
		$jack_well_sidebar_position = jack_well_get_theme_option('sidebar_position');
		?>
		<div class="sidebar <?php echo esc_attr($jack_well_sidebar_position); ?> widget_area<?php if (!jack_well_is_inherit(jack_well_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(jack_well_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'jack_well_action_before_sidebar' );
				jack_well_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $jack_well_out));
				do_action( 'jack_well_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>