<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('jack_well_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'jack_well_revslider_theme_setup9', 9 );
	function jack_well_revslider_theme_setup9() {

		add_filter( 'jack_well_filter_merge_styles',				'jack_well_revslider_merge_styles' );
		
		if (is_admin()) {
			add_filter( 'jack_well_filter_tgmpa_required_plugins','jack_well_revslider_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'jack_well_revslider_tgmpa_required_plugins' ) ) {
	
	function jack_well_revslider_tgmpa_required_plugins($list=array()) {
		if (jack_well_storage_isset('required_plugins', 'revslider')) {
			$path = jack_well_get_file_dir('plugins/revslider/revslider.zip');
			if (!empty($path) || jack_well_get_theme_setting('tgmpa_upload')) {
				$list[] = array(
					'name' 		=> jack_well_storage_get_array('required_plugins', 'revslider'),
					'slug' 		=> 'revslider',
					'version'	=> '6.6.10',
					'source'	=> !empty($path) ? $path : 'upload://revslider.zip',
					'required' 	=> false
				);
			}
		}
		return $list;
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'jack_well_exists_revslider' ) ) {
	function jack_well_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}
	
// Merge custom styles
if ( !function_exists( 'jack_well_revslider_merge_styles' ) ) {
	
	function jack_well_revslider_merge_styles($list) {
		if (jack_well_exists_revslider()) {
			$list[] = 'plugins/revslider/_revslider.scss';
		}
		return $list;
	}
}
?>