<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('jack_well_mailchimp_get_css')) {
	add_filter('jack_well_filter_get_css', 'jack_well_mailchimp_get_css', 10, 2);
	function jack_well_mailchimp_get_css($css, $args) {
		
		if (isset($css['fonts']) && isset($args['fonts'])) {
			$fonts = $args['fonts'];
			$css['fonts'] .= <<<CSS
form.mc4wp-form .mc4wp-form-fields input[type="email"] {
	{$fonts['input_font-family']}
	{$fonts['input_font-size']}
	{$fonts['input_font-weight']}
	{$fonts['input_font-style']}
	{$fonts['input_line-height']}
	{$fonts['input_text-decoration']}
	{$fonts['input_text-transform']}
	{$fonts['input_letter-spacing']}
}
form.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}

CSS;
		}		

		if (isset($css['vars']) && isset($args['vars'])) {
			$vars = $args['vars'];
			
			$css['vars'] .= <<<CSS

form.mc4wp-form .mc4wp-form-fields input[type="email"],
form.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	-webkit-border-radius: {$vars['rad']};
	    -ms-border-radius: {$vars['rad']};
			border-radius: {$vars['rad']};
}

CSS;
		}

		
		if (isset($css['colors']) && isset($args['colors'])) {
			$colors = $args['colors'];
			$css['colors'] .= <<<CSS

		
.sidebar form.mc4wp-form,
.sidebar .widget_mc4wp_form_widget .form.mc4wp-form,
.scheme_self.sidebar .widget_mc4wp_form_widget .form.mc4wp-form,
.wpb_widgetised_column .mc4wp-form{
	background-color: {$colors['alter_bg_color']};
}	
form.mc4wp-form .mc4wp_form_input_wrapper {
	border-color: {$colors['bd_color']};
}			
form.mc4wp-form .mc4wp_form_input_wrapper button:before {
	color: {$colors['inverse_text']};
}
form.mc4wp-form .mc4wp-alert {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['text_link']};
	color: {$colors['text']};
}
.mc4wp-response a{
		color: {$colors['text_link']};
}
.mc4wp-response a:hover{
		color: {$colors['text_hover']};
}

CSS;
		}

		return $css;
	}
}
?>