<?php
// Add plugin-specific colors and fonts to the custom CSS
if (!function_exists('jack_well_give_get_css')) {
	add_filter('jack_well_filter_get_css', 'jack_well_give_get_css', 10, 2);
	function jack_well_give_get_css($css, $args) {
		
		if (isset($css['fonts']) && isset($args['fonts'])) {
			$fonts = $args['fonts'];
			$css['fonts'] .= <<<CSS
			
		.give-goal-progress .raised,
		.give-card .give-goal-progress {
			{$fonts['info_font-family']}
		}	
		
		.give-form fieldset legend {
			{$fonts['h5_font-family']}
		}
	
CSS;
		}		

		if (isset($css['vars']) && isset($args['vars'])) {
			$vars = $args['vars'];
			
			$css['vars'] .= <<<CSS

CSS;
		}
		
		if (isset($css['colors']) && isset($args['colors'])) {
			$colors = $args['colors'];
			$css['colors'] .= <<<CSS
	
	
		.give-wrap {
			color: {$colors['text']};
		}
		
		.give-wrap .give-card {
			background-color: {$colors['bg_color']};
		}

		.ua_edge .give-card .give-card__title{
			color: {$colors['text_dark']} !important;
		}			
		.give-card:hover .give-card__title {
			color: {$colors['text_hover']};
		}		
		.ua_edge .give-card:hover .give-card__title {
			color: {$colors['text_hover']} !important;
		}
	
		.give-goal-progress .income {
			color: {$colors['text_link']} !important;
		}			
		.give-form input[type="radio"] + label:before {
			background-color: {$colors['alter_bg_color']};
		}
		form[id*="give-form"] .give-donation-amount #give-amount, 
		form[id*="give-form"] .give-donation-amount #give-amount-text	{
			color: {$colors['input_light']};
			border-color: {$colors['bd_color']};
		}	
		form[id*="give-form"] .give-donation-amount .give-currency-symbol {
			color: {$colors['inverse_text']};
			background-color: {$colors['text_link']};
			border-color: {$colors['text_link']};
		}		
		form[id*="give-form"] #give-final-total-wrap .give-donation-total-label {
			color: {$colors['inverse_text']};
			background-color: {$colors['extra_bg_color']};
			border-color: {$colors['extra_bg_color']};
		}	

		form[id*="give-form"] #give-final-total-wrap .give-final-total-amount {
			color: {$colors['input_light']};
		}		
				
		[id*="give-form"].give-fl-form .give-fl-is-required:before	{
			color: {$colors['text_link']};
		}				
		
		.give-wrap .give-card__text,
		.give-wrap .give-card .give-card__text,
		.give-card:hover .give-wrap .give-card__text {
			color: {$colors['text']};
			border-color: {$colors['bd_color']};
		}
		
		.give_success {
			border-color: {$colors['text_hover']};
		}		
		.give_success:before {
			background-color: {$colors['text_hover']};
		}
		
		.give_error {
			border-color: {$colors['text_link']};
		}		
		.give_error:before {
			background-color: {$colors['text_link']};
		}
		
		.give-card .give-goal-progress .raised {
			color: {$colors['text']};
		}		
		.give-card:hover .give-goal-progress .raised {
			color: {$colors['text_hover']} !important;
		}
		

		

CSS;
		}

		return $css;
	}
}
?>