<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

jack_well_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	jack_well_show_layout(get_query_var('blog_archive_start'));

	?><div class="posts_container"><?php
	
	$jack_well_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$jack_well_sticky_out = jack_well_get_theme_option('sticky_style')=='columns' 
							&& is_array($jack_well_stickies) && count($jack_well_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($jack_well_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	while ( have_posts() ) { the_post(); 
		if ($jack_well_sticky_out && !is_sticky()) {
			$jack_well_sticky_out = false;
			?></div><?php
		}
		get_template_part( 'content', $jack_well_sticky_out && is_sticky() ? 'sticky' : 'excerpt' );
	}
	if ($jack_well_sticky_out) {
		$jack_well_sticky_out = false;
		?></div><?php
	}
	
	?></div><?php

	jack_well_show_pagination();

	jack_well_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>