<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

jack_well_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	jack_well_show_layout(get_query_var('blog_archive_start'));

	$jack_well_classes = 'posts_container '
						. (substr(jack_well_get_theme_option('blog_style'), 0, 7) == 'classic' ? 'columns_wrap columns_padding_bottom' : 'masonry_wrap');
	$jack_well_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$jack_well_sticky_out = jack_well_get_theme_option('sticky_style')=='columns' 
							&& is_array($jack_well_stickies) && count($jack_well_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($jack_well_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	if (!$jack_well_sticky_out) {
		if (jack_well_get_theme_option('first_post_large') && !is_paged() && !in_array(jack_well_get_theme_option('body_style'), array('fullwide', 'fullscreen'))) {
			the_post();
			get_template_part( 'content', 'excerpt' );
		}
		
		?><div class="<?php echo esc_attr($jack_well_classes); ?>"><?php
	}
	while ( have_posts() ) { the_post(); 
		if ($jack_well_sticky_out && !is_sticky()) {
			$jack_well_sticky_out = false;
			?></div><div class="<?php echo esc_attr($jack_well_classes); ?>"><?php
		}
		get_template_part( 'content', $jack_well_sticky_out && is_sticky() ? 'sticky' : 'classic' );
	}
	
	?></div><?php

	jack_well_show_pagination();

	jack_well_show_layout(get_query_var('blog_archive_end'));

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>