<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_blog_style = explode('_', jack_well_get_theme_option('blog_style'));
$jack_well_columns = empty($jack_well_blog_style[1]) ? 2 : max(2, $jack_well_blog_style[1]);
$jack_well_expanded = !jack_well_sidebar_present() && jack_well_is_on(jack_well_get_theme_option('expand_content'));
$jack_well_post_format = get_post_format();
$jack_well_post_format = empty($jack_well_post_format) ? 'standard' : str_replace('post-format-', '', $jack_well_post_format);
$jack_well_animation = jack_well_get_theme_option('blog_animation');
$jack_well_components = jack_well_array_get_keys_by_value(jack_well_get_theme_option('meta_parts'));
$jack_well_counters = jack_well_array_get_keys_by_value(jack_well_get_theme_option('counters'));

?><div class="<?php echo 'classic' == $jack_well_blog_style[0] ? 'column' : 'masonry_item masonry_item'; ?>-1_<?php echo esc_attr($jack_well_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_format_'.esc_attr($jack_well_post_format)
					. ' post_layout_classic post_layout_classic_'.esc_attr($jack_well_columns)
					. ' post_layout_'.esc_attr($jack_well_blog_style[0]) 
					. ' post_layout_'.esc_attr($jack_well_blog_style[0]).'_'.esc_attr($jack_well_columns)
					); ?>
	<?php echo (!jack_well_is_off($jack_well_animation) ? ' data-animation="'.esc_attr(jack_well_get_animation_classes($jack_well_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Post taxonomies
	$tags = get_the_tag_list( '<span class="post_meta_item post_tags"><span class="post_meta_label">'.'</span> ', ' ', '</span>' );

	// Featured image
	jack_well_show_post_featured( array( 'thumb_size' => jack_well_get_thumb_size($jack_well_blog_style[0] == 'classic'
													? (strpos(jack_well_get_theme_option('body_style'), 'full')!==false 
															? ( $jack_well_columns > 2 ? 'big' : 'huge' )
															: (	$jack_well_columns > 2
																? ($jack_well_expanded ? 'big' : 'med')
																: ($jack_well_expanded ? 'big' : 'med')
																)
														)
													: (strpos(jack_well_get_theme_option('body_style'), 'full')!==false 
															? ( $jack_well_columns > 2 ? 'masonry-big' : 'full' )
															: (	$jack_well_columns <= 2 && $jack_well_expanded ? 'masonry-big' : 'masonry')
														)
								),
								'post_info' => !empty($tags) ? '<div class="post_info"><div class="post_tags">'.$tags.'</div></div>' : ''
		)
	);

	if ( !in_array($jack_well_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('jack_well_action_before_post_meta'); 

			// Post meta
			if (!empty($jack_well_components))
				jack_well_show_post_meta(apply_filters('jack_well_filter_post_meta_args', array(
					'components' => $jack_well_components,
					'counters' => $jack_well_counters,
					'seo' => false
					), $jack_well_blog_style[0], $jack_well_columns)
				);

			do_action('jack_well_action_after_post_meta'); 			
			
			do_action('jack_well_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$jack_well_show_learn_more = true;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($jack_well_post_format, array('link', 'aside', 'status'))) {
				the_content();
			} else if ($jack_well_post_format == 'quote') {
				if (($quote = jack_well_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
					jack_well_show_layout(wpautop($quote));
				else
					the_excerpt();
			} else if (substr(get_the_content(), 0, 4)!='[vc_') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($jack_well_post_format, array('link', 'aside', 'status', 'quote'))) {
			if (!empty($jack_well_components))
				jack_well_show_post_meta(apply_filters('jack_well_filter_post_meta_args', array(
					'components' => $jack_well_components,
					'counters' => $jack_well_counters
					), $jack_well_blog_style[0], $jack_well_columns)
				);
		}
		// More button
		if ( $jack_well_show_learn_more ) {
			?><p class="more-link-block"><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'jack-well'); ?></a></p><?php


			$author_id = get_the_author_meta('ID');
			if (empty($author_id) && !empty($GLOBALS['post']->post_author))
				$author_id = $GLOBALS['post']->post_author;
			if ($author_id > 0) {
				$author_link = get_author_posts_url($author_id);
				$author_name = get_the_author_meta('display_name', $author_id);
				?>
				<a class="post_meta_item post_author" rel="author" href="<?php echo esc_url($author_link); ?>">
					<?php esc_html_e('by ', 'jack-well')?>
					<?php echo esc_html($author_name); ?>
				</a>
				<?php
			}

		}
		?>
	</div><!-- .entry-content -->

</article></div>