<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

$jack_well_blog_style = explode('_', jack_well_get_theme_option('blog_style'));
$jack_well_columns = empty($jack_well_blog_style[1]) ? 1 : max(1, $jack_well_blog_style[1]);
$jack_well_expanded = !jack_well_sidebar_present() && jack_well_is_on(jack_well_get_theme_option('expand_content'));
$jack_well_post_format = get_post_format();
$jack_well_post_format = empty($jack_well_post_format) ? 'standard' : str_replace('post-format-', '', $jack_well_post_format);
$jack_well_animation = jack_well_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($jack_well_columns).' post_format_'.esc_attr($jack_well_post_format) ); ?>
	<?php echo (!jack_well_is_off($jack_well_animation) ? ' data-animation="'.esc_attr(jack_well_get_animation_classes($jack_well_animation)).'"' : ''); ?>>

	<?php
	// Add anchor
	if ($jack_well_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.the_title_attribute( array( 'echo' => false ) ).'" icon="'.esc_attr(jack_well_get_post_icon()).'"]');
	}

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	jack_well_show_post_featured( array(
											'class' => $jack_well_columns == 1 ? 'jack_well-full-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => jack_well_get_thumb_size(
																	strpos(jack_well_get_theme_option('body_style'), 'full')!==false
																		? ( $jack_well_columns > 1 ? 'huge' : 'original' )
																		: (	$jack_well_columns > 2 ? 'big' : 'huge')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('jack_well_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('jack_well_action_before_post_meta'); 

			// Post meta
			$jack_well_components = jack_well_array_get_keys_by_value(jack_well_get_theme_option('meta_parts'));
			$jack_well_counters = jack_well_array_get_keys_by_value(jack_well_get_theme_option('counters'));
			$jack_well_post_meta = empty($jack_well_components) 
										? '' 
										: jack_well_show_post_meta(apply_filters('jack_well_filter_post_meta_args', array(
												'components' => $jack_well_components,
												'counters' => $jack_well_counters,
												'seo' => false,
												'echo' => false
												), $jack_well_blog_style[0], $jack_well_columns)
											);
			jack_well_show_layout($jack_well_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$jack_well_show_learn_more = !in_array($jack_well_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($jack_well_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($jack_well_post_format == 'quote') {
					if (($quote = jack_well_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						jack_well_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 4)!='[vc_') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($jack_well_post_format, array('link', 'aside', 'status', 'quote'))) {
				jack_well_show_layout($jack_well_post_meta);
			}
			// More button
			if ( $jack_well_show_learn_more ) {
				?><p class="more-link-block"><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'jack-well'); ?></a></p><?php

				$author_id = get_the_author_meta('ID');
				if (empty($author_id) && !empty($GLOBALS['post']->post_author))
					$author_id = $GLOBALS['post']->post_author;
				if ($author_id > 0) {
					$author_link = get_author_posts_url($author_id);
					$author_name = get_the_author_meta('display_name', $author_id);
					?>
					<a class="post_meta_item post_author" rel="author" href="<?php echo esc_url($author_link); ?>">
						<?php esc_html_e('by ', 'jack-well')?>
						<?php echo esc_html($author_name); ?>
					</a>
					<?php
				}




			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>