<?php
/**
 * The template to display blog archive
 *
 * @package WordPress
 * @subpackage JACK_WELL
 * @since JACK_WELL 1.0
 */

/*
Template Name: Blog archive
*/

/**
 * Make page with this template and put it into menu
 * to display posts as blog archive
 * You can setup output parameters (blog style, posts per page, parent category, etc.)
 * in the Theme Options section (under the page content)
 * You can build this page in the WordPress editor or any Page Builder to make custom page layout:
 * just insert %%CONTENT%% in the desired place of content
 */

// Get template page's content
$jack_well_content = '';
$jack_well_blog_archive_mask = '%%CONTENT%%';
$jack_well_blog_archive_subst = sprintf('<div class="blog_archive">%s</div>', $jack_well_blog_archive_mask);
if ( have_posts() ) {
	the_post();
	if (($jack_well_content = apply_filters('the_content', get_the_content())) != '') {
		if (($jack_well_pos = strpos($jack_well_content, $jack_well_blog_archive_mask)) !== false) {
			$jack_well_content = preg_replace('/(\<p\>\s*)?'.$jack_well_blog_archive_mask.'(\s*\<\/p\>)/i', $jack_well_blog_archive_subst, $jack_well_content);
		} else
			$jack_well_content .= $jack_well_blog_archive_subst;
		$jack_well_content = explode($jack_well_blog_archive_mask, $jack_well_content);
		// Add VC custom styles to the inline CSS
		$vc_custom_css = get_post_meta( get_the_ID(), '_wpb_shortcodes_custom_css', true );
		if ( !empty( $vc_custom_css ) ) jack_well_add_inline_css(strip_tags($vc_custom_css));
	}
}

// Prepare args for a new query
$jack_well_args = array(
	'post_status' => current_user_can('read_private_pages') && current_user_can('read_private_posts') ? array('publish', 'private') : 'publish'
);
$jack_well_args = jack_well_query_add_posts_and_cats($jack_well_args, '', jack_well_get_theme_option('post_type'), jack_well_get_theme_option('parent_cat'));
$jack_well_page_number = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
if ($jack_well_page_number > 1) {
	$jack_well_args['paged'] = $jack_well_page_number;
	$jack_well_args['ignore_sticky_posts'] = true;
}
$jack_well_ppp = jack_well_get_theme_option('posts_per_page');
if ((int) $jack_well_ppp != 0)
	$jack_well_args['posts_per_page'] = (int) $jack_well_ppp;
// Make a new main query
$GLOBALS['wp_the_query']->query($jack_well_args);


// Add internal query vars in the new query!
if (is_array($jack_well_content) && count($jack_well_content) == 2) {
	set_query_var('blog_archive_start', $jack_well_content[0]);
	set_query_var('blog_archive_end', $jack_well_content[1]);
}

get_template_part('index');
?>